//		Copyright (c) 1999 by
//		Advanced Visual Systems Inc.
//		All Rights Reserved
//
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//
//      This file is under Perforce control
//      $Id: //depot/express/fcs70/dbil/dbil_query.hxx#1 $
//

//
// file: dbil_query.hxx
// author: Patrick Li, Advanced Visual System
// purpose: Define DBIL_Query class
//
//  This class opens and maintains a query against the spatial engine specified by 
//  the DBIL_Connection. The query remains open until all the rows are fetched.
//
#ifndef DBIL_QUERY_DEFINED
#define DBIL_QUERY_DEFINED

#include "dbil_connect.hxx"
#include "dbil_shp_arr.hxx"

// Define DBIL_Query class
//
class DBIL_Query : public DBIL_Error_Tool {
public:
   // Constructor and Destructor
   //
   DBIL_Query();
   virtual ~DBIL_Query();

   // Setup a basic SQL query
   //
   DBIL_Status Setup( DBIL_Connection *in_connection, char *sql_statement, int rows_per_fetch,
							int userbuf_realloc_interval, int max_rows);
/*   
   // Setup a spatial query
   //
   DBIL_Status Setup( DBIL_Connection *in_connection, int num_tables, char **tables, 
                     char *where, char *shape, char *field, int num_attrs, char **attributes, 
                     DBIL_Shape *filter_shape, DBIL_FILTER_METHODS filter_method );
*/
	DBIL_Status Execute( DBIL_Connection *in_connection, int iteration );
	DBIL_Status Define( DBIL_Connection *in_connection );

   // Setup Fetch parameters
   // 
   DBIL_Status SetupFetch( int in_rows_per_fetch, int in_fetch_all, int in_max_rows );
   DBIL_Status SetRowsPerFetch( int in_rows_per_fetch );
   DBIL_Status SetLoop( int in_loop );
   DBIL_Status SetFetchAll( int in_fetch_all );
   DBIL_Status SetMaxRows( int in_max_rows );
   DBIL_Status SetFlushWhenFull( int in_flush_when_full );
   DBIL_Status SetQueryTimeoutSecs( int in_query_timeout_secs );
   DBIL_Status SetUserbufReallocInterval(int in_userbuf_realloc_interval );
   DBIL_Status SetUseFloatingTypeOnly(int in_use_floating_type_only );
   DBIL_Status SetFloatingType(int in_floating_type );
   DBIL_Status SetFixedType(int in_fixed_type );
   DBIL_Status SetRowSpecificErrorCnt( int in_row_specific_error_cnt );
   DBIL_Status SetNullValue( unsigned char null_value );
   DBIL_Status SetNullValue( short null_value );
   DBIL_Status SetNullValue( int null_value );
   DBIL_Status SetNullValue( unsigned int null_value );
   DBIL_Status SetNullValue( float null_value );
   DBIL_Status SetNullValue( double null_value );
   DBIL_Status SetNullValue( char* null_value );
   // Fetch attributes, shapes, and fields from current query
   //
//   DBIL_Status Fetch( DBIL_Shape *shape );
//   DBIL_Status Fetch( DBIL_Shape_Array *shapes, DBIL_Status_Callback cb = NULL );
   DBIL_Status Fetch( int *num_attrs, DBIL_Attribute **attrs,  
		void* cb = NULL, signed char **in_null_ind = NULL, void* ptr = NULL, short new_fetch = 1);

   // Check to see if there is a valid query
   //
   int IsValid();

	// Release user buffers 
	void ReleaseUserBuffer();
	// Release space if prepareStatement/query failed or deinstanced 
	void CloseCursor();

   // Methods to get parameters about the current query
   //
   const char *GetTable() { return cursor.table; }
   const char *GetShapeName() { return cursor.shape_name; }
   const char *GetFieldName() { return cursor.field_name; }
   int GetNumAttributes() { return cursor.num_attrs; }
	int GetRowSpecificError_cnt(){return cursor.output_stat.row_specific_error_cnt;}
   DBIL_Status SetAttrNulls( int num_attrs, DBIL_Attribute *attrs);

	const DB_OUTPUT_STAT *GetOutputStatistics() const {return &(cursor.output_stat);}
	void ResetOutputStatistics();
	long **GetNullIndicators() const {return cursor.indicators;}
   void SigHandler ();
private:
   // Connection and cursor information
   //
   DBIL_Cursor cursor;
   DBIL_Connection *connection;

   // Fetch parameters
   //
	int flush_when_full;
	int query_timeout_secs;
	int userbuf_realloc_interval;
   int fetch_all;
   int max_rows;
	int loop;
	int cancel_button;
	short new_statement;

	// User buffers
	DBIL_Attribute * attrs;
	signed char * null_ind;

	// Allocate space for the pointer arrays
	DBIL_Status DBIL_InitBuffers(int num_attrs); 

   // Create private copy constructor and assignment operator 
   // to invalidate copys and assignments
   //
   DBIL_Query( const DBIL_Query & ) {}
   DBIL_Query &operator=(const DBIL_Query &) { return *this; }
	void SetAlarm();
	DBIL_Status CancelAlarm();
};
#endif
