//		Copyright (c) 1999 by
//		Advanced Visual Systems Inc.
//		All Rights Reserved
//
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//
//      This file is under Perforce control
//      $Id: //depot/express/fcs70/dbil/dbil_shp_arr.hxx#1 $
//

//
// file: dbil_shp_arr.hxx
// author: Patrick Li, Advanced Visual System
// purpose: Maintain an array (actually a linked list) of shapes
//
#ifndef DBIL_SHP_ARR_DEFINED
#define DBIL_SHP_ARR_DEFINED

#include "dbil_shape.hxx"

// define DBIL_Shape_Entry class
//
class DBIL_Shape_Entry : public DBIL_Shape {
public:
   // Constructors
   //
   DBIL_Shape_Entry( DBIL_Shape_Entry *previous, DBIL_Shape_Entry *next );
   DBIL_Shape_Entry( DBIL_Shape &shape, DBIL_Shape_Entry *previous, DBIL_Shape_Entry *next );

   // Destructor
   //
   ~DBIL_Shape_Entry();

   // Get next and previous
   //
   DBIL_Shape_Entry *GetNext()
      { return( next ); }

   DBIL_Shape_Entry *GetPrevious()
      { return( previous ); }

private:
   DBIL_Shape_Entry *previous;
   DBIL_Shape_Entry *next;
};

// Define DBIL_Shape_Array class which maintains a list of entries
//
class DBIL_Shape_Array {
public:
   // Constructor
   //
   DBIL_Shape_Array();

   // Destructor
   //
   virtual ~DBIL_Shape_Array();

   // Basic setup
   //
   void SetName( const char *name );
   void SetFieldName( const char *name );

   // Add shapes to list
   //
   DBIL_Shape *Add();
   DBIL_Shape *Add( DBIL_Shape &shape );

   // Get specified shape from list
   //
   DBIL_Shape *Get( int index );

   // Delete a shape from the list
   //
   void Delete( DBIL_Shape *entry );

   // Return number of entries in list
   //
   int GetNumEntries() 
      { return num_entries; }

private:
   int num_entries;
   DBIL_Shape_Entry *first;
   DBIL_Shape_Entry *last;

   // Create private copy constructor and assignment operator 
   // to invalidate copys and assignments
   //
   DBIL_Shape_Array( const DBIL_Shape_Array & ) {}
   DBIL_Shape_Array &operator=(const DBIL_Shape_Array &) { return *this; }
};
#endif

