//		Copyright (c) 1999 by
//		Advanced Visual Systems Inc.
//		All Rights Reserved
//
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//
//      This file is under Perforce control
//      $Id: //depot/express/fcs70/dbil/dbil_transaction.hxx#1 $
//


// file: dbil_transaction.hxx
// author: Patrick Li, Advanced Visual Systems
// purpose: Define DBIL_Transaction class
//
#ifndef DBIL_TRANSACTION_DEFINED
#define DBIL_TRANSACTION_DEFINED 1

#include <avs/dbil.h>
#include "dbil_error.hxx"

class DBIL_Connection;

// Define DBIL_Transaction class
//
class DBIL_Transaction : public DBIL_Error_Tool {
public:
   enum transaction_states { Closed, Open };

   DBIL_Transaction();
   virtual ~DBIL_Transaction();

   // Set and get connection information for this transaction
   //
   void SetConnection( DBIL_Connection *connect );
   DBIL_Connection *GetConnection() const { return connection; }

   // Start a transaction on the specified connection
   //
   DBIL_Status SetState( transaction_states new_state );

   // Commit or rollback the current transaction
   //
   DBIL_Status Commit();
   DBIL_Status Rollback();

   // Set and get transaction parameters
   //
   void SetAutoRollback( int flag );
   int GetAutoRollback() { return auto_rollback; }

private:
   transaction_states state;

   int auto_rollback;
   DBIL_Connection *connection;

   // Create private copy constructor and assignment operator 
   // to invalidate copys and assignments
   //
   DBIL_Transaction( const DBIL_Transaction & ) {}
   DBIL_Transaction &operator=(const DBIL_Transaction &) { return *this; }
};
#endif
