//			Copyright (c) 2003 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/demos/v/apps/climate.v#1 $

// This demo inherits from the Demo3DMultiWindowApp template. This
// template provides some standard functionality which is shared
// amongst the demos.

DEMOS.Macros.Demo3DMultiWindowApp Climate<NEsmallPixmapName="$XP_PATH<0>/demos/icons/climate.bmp",NEhelpFile="demos/Climate.html",NEdisplayMode="maximized"> {

   UI {
      shell {
         x = 60;
         y = 10;
      };
   };

// The top level params block is used to store common variables that are
// used throughout the application. Typically, this is also the approach
// used to store application state.

   params {
      title = "Climate Data Demo";
      image = "climate.bmp";
      info_text = "This demo shows how mulitple data\ntypes can be displayed in a single\nview and how multiple views can be\nachieved";
      int animate_wind<NEportLevels=1> = 0;
      int animate_slices<NEportLevels=1> = 0;
   };

// The Info macro is inherited from the Demo3DMultiWindowApp template. This
// contains some standard  GUI shared amongst the demos. Here we add in some
// UI and behaviour specific to this demo

   Info {
      Text {
      	 height => UIdata.UIfonts[0].height * 5; //5 lines of text
      };
      UItoggle Animate_Wind {
         width = 120;
         y => UIbuttonHtml.Help.y + UIbuttonHtml.Help.height + 8;
         parent => <-.Summary;
         set => params.animate_wind;
      };
      UItoggle Animate_Slices {
         width = 120;
         y => Animate_Wind.y + Animate_Wind.height;
         parent => <-.Summary;
         set => params.animate_slices;
      };
   };

   macro rect_climate {
      macro rectUI {
         UImod_panel Move_wind_plane<NEportLevels={0,2}>;
      };
      MODS.bounds bounds {
         in_field => <-.Read_Rect_Data.field;
         out_obj<NEportLevels={1,3}>;
      };
      MODS.isosurface Isosurface_Rect {
         in_field => <-.Read_Rect_Data.field;
         IsoParam {
            iso_component = 4;
            iso_level => 296.46;
            map_component = {3};
         };
         UIpanel {
            title => "Isosurface (Rect)";
         };
         out_obj<NEportLevels={1,3}>;
      };
      GEOMS.FPlane FPlane {
         in => <-.Read_Rect_Data.field;
         plane {
            xform {
               mat = {
                  1.,0.,0.,0.,0.,5e-010,1.,0.,0.,-1.,5e-010,0.,0.,0.,0.,1.
               };
            };
         };
         probe_ui {
            xform_toggle {
               y => 10;
               parent<NEportLevels={4,0}> => <-.<-.<-.rectUI.Move_wind_plane;
               label = "Transform Advect Plane";
            };
            probe_edit {
               GDxform_editor {
                  x_rot = 90.;
                  abs_x_rot = 90.;
               };
               XformEditorUI {
                  trans_shell {
                     ok = 1;
                  };
               };
            };
         };
      };
      MODS.advector advector {
         in_field => <-.combine_vect.out_fld;
         in_probe => <-.FPlane.out_fld;
         in_glyph => <-.Cool_Arrow.out_fld;
         AdvectParam {
            run => params.animate_wind;
            cycle = 1;
            end = 30.;
            incr = 0.1;
            count = 7.5;
            scale = 2.57;
            normalize = 1.;
         };
         UIpanel {
            title => "Animate Wind";
         };
         obj1 {
            Props {
               col = {0.85,0.85,0.85};
               inherit = 0;
            };
         };
         out_obj<NEportLevels={1,3}>;
      };
      MODS.combine_vect combine_vect {
         in_field => <-.Read_Rect_Data.field;
      };
      GEOMS.Arrow3 Cool_Arrow;
      NETCDF.Read_Field Read_Rect_Data {
         Read_NetCDF_Param {
            filename = "$XP_PATH<0>/demos/data/climate/rect.nc";
            selectedVariables = {0,1,2,3,4};
            trigger = 1;
         };
      };
      HDF5.Rd_HDF5_Field Rd_HDF5_Field {
         Rd_HDF5_Param {
            filename = "$XP_PATH<0>/demos/data/climate/mission.h5";
            trigger = 1;
         };
         read_field {
            Mesh_Unif+Node_Data Output_Field;
         };
         Rd_HDF5_UI {
            choose_node_vars {
               label_cmd {
                  cmd[1] = {
                     {
                        set=1,,,,,,,,,,,,,,,,,,,,
                     }};
               };
            };
         };
         out_obj<NEportLevels={1,3}>;
      };
   };
   macro sphere_climate {
      macro AnimateSlices {
         GMOD.loop loop_NS {
            run => <-.<-.<-.params.animate_slices;
            cycle = 1;
            start_val = 0.;
            end_val = 48.;
            incr = 1.;
            count<NEportLevels={0,3}> = 21.;
         };
      };
      MODS.orthoslice orthoslice_surface {
         in_field => <-.Surface_Component.out_fld;
         OrthoSliceParam {
            axis = 1;
            plane => 0;
         };
         obj {
            Props {
               jitter = -5;
               inherit = 0;
            };
         };
         out_obj<NEportLevels={1,3}>;
      };
      MODS.orthoslice orthoslice_NS {
         in_field => <-.extract_scalar_axis.out_fld;
         OrthoSliceParam {
            plane<NEportLevels={3,2}> => <-.<-.AnimateSlices.loop_NS.count;
         };
         OrthoSliceUI {
            UIpanel {
               title => "North-South Slice";
            };
         };
         out_obj<NEportLevels={1,3}>;
      };
      MODS.orthoslice orthoslice_EW {
         in_field => <-.extract_scalar_axis.out_fld;
         OrthoSliceParam {
            axis = 2;
            plane<NEportLevels={3,2}> => switch((<-.<-.AnimateSlices.loop_NS.count < 40),<-.<-.AnimateSlices.loop_NS.count);
         };
         OrthoSliceUI {
            UIpanel {
               title => "East-West Slice";
            };
         };
         out_obj<NEportLevels={1,3}>;
      };
      MODS.isosurface isosurface_sphere {
         in_field => <-.Read_Sphere_Data.field;
         IsoParam {
            iso_level => 34.28;
            map_component = {0,4};
         };
         UIpanel {
            title => "Isosurface (Sphere)";
         };
         IsoUI {
            UIradioBoxLabel {
               label_cmd {
                  cmd[5];
               };
            };
            UIoptionBoxLabel {
               label_cmd {
                  cmd[5] = {
                     ,,,,
                     {
                        set=1,,,,,,,,,,,,,,,,,,,,
                     }
                  };
               };
            };
         };
         out_obj<NEportLevels={1,3}>;
      };
      MODS.extract_scalar extract_scalar_axis {
         in_field => <-.Read_Sphere_Data.field;
         ExtractScalarParam {
            vector = 3;
         };
      };
      MODS.extract_scalar Surface_Component {
         in_field => <-.Read_Sphere_Data.field;
         ExtractScalarParam {
            vector = 4;
         };
         ExtractScalarUI {
            UIradioBoxLabel {
               label_cmd {
                  cmd[5] = {
                     ,,,,
                     {
                        set=1,,,,,,,,,,,,,,,,,,,,
                     }
                  };
                  outItem => inItem;
               };
            };
         };
      };
      NETCDF.Read_Field Read_Sphere_Data {
         Read_NetCDF_Param {
            filename = "$XP_PATH<0>/demos/data/climate/sphere.nc";
            selectedVariables = {0,1,2,3,4};
            trigger = 1;
         };
      };
      HDF5.Rd_HDF5_Field Read_Globe_Map {
         Rd_HDF5_Param {
            filename = "$XP_PATH<0>/demos/data/climate/globe_map.h5";
            trigger = 1;
         };
         out_obj<NEportLevels={1,3}>;
      };
   };
   GDM.Uviewer3D Uviewer3D {
      Scene {
         Top {
            child_objs => {
               <-.<-.<-.rect_climate.advector.out_obj,
               <-.<-.<-.rect_climate.Isosurface_Rect.out_obj,
               <-.<-.<-.rect_climate.bounds.out_obj,
               <-.<-.<-.rect_climate.Rd_HDF5_Field.out_obj};
            Xform {
               dcenter = {-0.0973029,0.,0.894368};
               mat = {
                  0.131918,-0.0613968,0.0726006,0.,0.0947289,0.0955456,-0.0913254,
                  0.,-0.00817636,0.11638,0.113277,0.,0.,0.,0.,1.
               };
               xlate = {0.0973029,0.,-0.894368};
               ocenter = {-0.598373,0.,5.5};
               center = {-0.598373,0.,5.5};
            };
         };
         Lights {
            Lights = {
               {
                  type="BiDirectional"
               },,,};
         };
         View {
            ViewUI {
               ViewPanel {
                  UI {
                     option.label = "Rectilinear Scene";
                     panel {
                        defaultX = 438;
                        defaultY = 0;
                     };
                  };
               };
            };
         };
         Camera {
            Camera {
               auto_norm = "None";
            };
         };
      };
      Scene_Selector {
         input_views => {Scene.View.View, <-.Scene#1.View.View};
      };
      Scene_Editor {
         Camera_Editor {
            GDcamera_edit {
               auto_norm = "None";
            };
         };
      };
      GDM.Uscene3D Scene#1 {
         Top {
            child_objs<NEportLevels={4,1}> => {
               <-.<-.<-.sphere_climate.orthoslice_surface.out_obj,
               <-.<-.<-.sphere_climate.orthoslice_NS.out_obj,
               <-.<-.<-.sphere_climate.orthoslice_EW.out_obj,
               <-.<-.<-.sphere_climate.isosurface_sphere.out_obj,
               <-.<-.<-.sphere_climate.Read_Globe_Map.out_obj
            };
            Xform {
               mat = {
                  -1.93896,1.21193,-1.98855,0.,2.32619,0.886387,-1.72797,0.,
                  -0.109407,-2.63216,-1.49749,0.,0.,0.,0.,1.
               };
            };
         };
         Lights {
            Lights = {
               {
                  type="BiDirectional"
               },,,};
         };
         View {
            ViewUI {
               ViewPanel {
                  UI {
                     option.label = "Sphere Scene";
                     panel {
                        defaultX = 438;
                        defaultY = 520;
                     };
                  };
               };
            };
         };
         Camera {
            Camera {
               auto_norm = "None";
            };
         };
      };
   };
};
