//			Copyright (c) 2003 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/demos/v/apps/image2volume.v#1 $

// This demo inherits from the Demo3D template. This template provides
// some standard functionality which is shared amongst the demos.

DEMOS.Macros.Demo3D Image2Volume<NEsmallPixmapName="$XP_PATH<0>/demos/icons/pollen.bmp",NEhelpFile="demos/Image2Volume.html",NEdisplayMode="maximized"> {

// The top level params block is used to store common variables that are
// used throughout the application. Typically, this is also the approach
// used to store application state.

   params {
      info_text = "This example shows how you can\nuse AVS/Express to read in a series\nof stacked TIFF images and then create\na volume. The volume may be visualized\nin a number of ways. This particular\nexample shows how the isosurface\nmodule can be used.";
      image = "image2vol.bmp";
      title = "Pollen Image Demo";
      double value<NEportLevels={1,1}> => <-.loop.count;
   };

// The Info macro is inherited from the Demo3D template. This contains some
// standard GUI shared amongst the demos. Here we add in some UI and behaviour
// specific to this demo.

   Info {
      UIslider Isosurface_Level {
         parent => <-.Summary;
         value<NEportLevels={2,2}> => <-.<-.params.value;
         y => UIbuttonHtml.Help.y + UIbuttonHtml.Help.height + 5;
         min<NEportLevels={2,0}> => <-.<-.Isosurface.IsoUI.UIiso_level.min;
         max<NEportLevels={2,0}> => <-.<-.Isosurface.IsoUI.UIiso_level.max;
         //height => UIdata.UIfonts[0].lineHeight * 2;
      };
      UItoggle Animate {
         parent => <-.Summary;
         y => Isosurface_Level.y + Isosurface_Level.height + 5;
      };
   };

   MODS.Read_Img2Vol Read_Img2Vol {
      Read_Img2VolParam<NEdisplayMode="open"> {
         filename_head = "$XP_PATH<0>/demos/data/pollen/medpol";
         filename_tail = ".tif";
         format = 8;
         start = 1;
         end = 31;
      };
      read_img2vol_ui {
         format_tiff {
            set = 1;
         };
         out_format_lumi {
            set = 1;
         };
      };
   };
   MODS.isosurface Isosurface {
      in_field => <-.Downsize.out_fld;
      IsoParam {
         iso_level => <-.<-.params.value;
      };
   };
   MODS.downsize Downsize {
      in_field => <-.Read_Img2Vol.out_fld;
      DownsizeParam {
         factor0 = 4.;
         factor1 = 4.;
         factor2 = 4.;
      };
   };
   MODS.bounds Bounds {
      in_field => <-.Read_Img2Vol.out_fld;
   };
   GMOD.loop loop {
      run => <-.Info.Animate.set;
      cycle = 2;
      start_val => <-.Isosurface.IsoUI.UIiso_level.min;
      end_val => <-.Isosurface.IsoUI.UIiso_level.max;
      incr = 0.02;
      count = 0.07;
      reset<NEportLevels={2,2}>;
      reset_back<NEportLevels={2,2}>;
   };

   Uviewer3D {
      Scene {
         Top {
            child_objs => {
               <-.<-.<-.Isosurface.out_obj,
               <-.<-.<-.Bounds.out_obj
            };
         };
      };
   };
};
