//			Copyright (c) 2003 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//	
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/demos/v/macros/demoapp.v#1 $

//	DemoAppTempl is the macro that contains the default parameters for
//	all of the high level Demos. 

macro DemoAppTempl {

// params is the top level parameter block. This group contains variables
// that are shared in the whole application. Each individual demo will add
// to the parameter block to store information on application state and
// new, application specific global variables.

   group params {
      string title<NEportLevels=1>;
      string filepath = "$XP_PATH<0>/demos/data/panel_images/";
      string image<NEportLevels=1>;
      string info_text<NEportLevels=1>;
   };
   
// The info macro contains the GUI elements for the Summary panel inside each
// demo. Extra application specific GUI will be added in the code for each of 
// the demos.

   macro Info {
      UImod_panel Summary;
      UIlabel Title {
      	 y = 0;
      	 width => parent.clientWidth;
      	 label => params.title;
      	 parent => <-.Summary;
      	 fontAttributes.weight = "bold";
      };

      UIlabel Text {
         y => Image.y + Image.height + 5;
         width => parent.clientWidth;
         parent => <-.Summary;
         label => params.info_text;
         // assuming 30 chars per line
         height => UIdata.UIfonts[0].height * (strlen(params.info_text) / 30);
      };
      UIlabel Image {
         y => UIdata.UIfonts[0].lineHeight + 5;
         width = 250;
         height => 220;
         parent => <-.Summary;
         labelPixmap {
            filename<NEdisplayMode="open"> => params.filepath + params.image;
         };
      };
      macro UIbuttonHtml {
         UIbutton Help {
            parent => <-.parent;
            x => ((parent.clientWidth / 2) - (width / 2));
            y => Text.y + Text.height + 5;
         };
         link parent<NEportLevels={2,1}> => <-.Summary;

         UIlaunchBrowser UIlaunchBrowser {
            trigger => <-.Help.do;         
            filename => str_format("demos/%s.html", <-.filename);
            use_helppath = 1;
         };

         string filename<NEportLevels=1> => name_of(<-.<-.<-);
      };
   };
};

// Demo3D is the macro that most of the demos will inherit from. This 
// demonstrates a typical programming approach in Express. The 
// APPS.SingleWindowApp is merged together with the DemoAppTempl
// to construct this object.

APPS.SingleWindowApp+DemoAppTempl Demo3D {
  UI {
      shell {
         x = 110;
         y = 115;
      };
      macro exit_dialog {
         UIcmd Exit<NEportLevels={0,2}> {
            label => "Exit Demonstration";
            message = "AU_EXIT_MSG";
         };
         GMOD.parse_v ExitProcess {
            trigger => <-.Exit.do;
            on_inst = 0;
            relative => <-;
            v_commands => str_format("- %s;",name_of(<-.<-.<-.<-));
            
         };
      };
   };

   GDM.Uviewer3D Uviewer3D;
};

// Demo3DMultiWindowApp is used by the climate demo. It uses the same base
// macro as Demo3D, but in this case we merge DemoAppTempl with 
// APPS.MultiWindowApp for a different look and feel.

APPS.MultiWindowApp+DemoAppTempl Demo3DMultiWindowApp {
  UI {
      shell {
         x = 110;
         y = 115;
      };
      macro exit_dialog {
         UIcmd Exit<NEportLevels={0,2}> {
            label => "Exit Demonstration";
            message = "AU_EXIT_MSG";
         };

// GMOD.parse_v can be used to add in v command that respond to user events.
// In this case, it is put to good use by creating a template to delete the
// current demo application. The way this works is that the v function
// name_of is used to get the name of the demo, which is then deleted from the
// Applications object container inside Express, using the - syntax. This also
// illustrates how str_format can be used to format strings in standard C style
// syntax.

         GMOD.parse_v ExitProcess<NEx=66.,NEy=77.> {
            trigger => <-.Exit.do;
            on_inst = 0;
            relative => <-;
            v_commands => str_format("- %s;",name_of(<-.<-.<-.<-));
         };
      };
   };

   GDM.Uviewer3D Uviewer3D;
};
  
