/*
			Copyright (c) 2004 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/gmod/demux.c#1 $
*/

#define XP_WIDE_API	/* Use Wide APIs */

#include <avs/om.h>

int GMODdemux_update( OMobj_id mod_id, OMevent_mask mask, int seq_num )
{
    OMobj_id out_arr_id, out_id;
    int stat, cmd = -1;

    stat = OMget_name_int_val( mod_id, OMstr_to_name("input"), &cmd );
    if( stat != OM_STAT_SUCCESS ) return 0;

    out_arr_id = OMfind_subobj( mod_id, OMstr_to_name("output"),
                            OM_OBJ_RW );

    stat = OMget_array_val( out_arr_id, cmd, &out_id, OM_OBJ_RW );
    if( stat != OM_STAT_SUCCESS ) return 0;

    stat = OMset_name_int_val( out_id, OMstr_to_name("trigger"), 0 );
    if( stat != OM_STAT_SUCCESS ) return 0;

    return 1;
}
