/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/gmod/errhandl.cxx#1 $
*/
/* An error-handling module.
   When the error package in tool/error.c gets an error message to handle,
   it calls a function that puts it into a string in this module.
   This module's init function registers the location of that string with
   the error package (and deregisters it when necessary), and installs the
   error-hook function that sends the current error to the registered
   string.
 */

#define XP_WIDE_API	/* Use Wide APIs */

#include "gmod/uci_gmod.h"
#include <avs/err.h>
#include <avs/util.h>

// We ignore severity for now
// data is a pointer to the obj id of the global error string object
// msg is the error message to be handled (displayed)
//   We handle it by stuffing it into the global error string object
// Return value of 0 means we couldn't handle this error, 1 means OK.
#if 0
// I put this declaration in to fix a Sun (Forte 6) compiler warning, but many
// other compilers don't like declaring a function both extern and static.
// Even the Sun WS 5.0 compilers won't accept it.
extern "C"
#endif
static int gmod_err_handler_func(void *data, char *msg, int) // severity
{
   GMOD_err_handler *my_obj = (GMOD_err_handler *) data;
   int ct;
   char *c;

   // count the number of newlines in the message.. This is needed so that
   // the display guy can keep track of how many lines are in the message
   // log.
   for (ct = 0, c = msg; *c != '\0'; c++)
      if (*c == '\n') ct++;

   my_obj->push_ctx(OM_STATE_TRANSIENT);
   my_obj->num_lines = ct;
   my_obj->err_message = msg;
   my_obj->pop_ctx();

   return 1;
}

#if 0
extern "C" {
    /* Works either way */
    /* DLL_IMPORT void UTILlic_set_error_callback( void *, void * ); */
    void UTILlic_set_error_callback( void *, void * );
}
#endif

int
GMOD_err_handler::instance(OMevent_mask mask, int)
{
   if ((mask & OM_EVENT_INST)) {
      if (enabled) {
	 ERRpush_error_dlg(gmod_err_handler_func, NULL, (void *)this);
         // Lic callback
         OMlic_set_err_callback( (void *)gmod_err_handler_func, (void *)this);
      }
      _enabled = enabled;
   }
   else if (_enabled != enabled) {
      if (_enabled) {
	 ERRpop_error_dlg(gmod_err_handler_func);
         // Note that this works correctly for relativly trivial
         // push/pop combinations.
         OMlic_set_err_callback( NULL, NULL );	// Lic callback
      }
      else {
	 ERRpush_error_dlg(gmod_err_handler_func, NULL, (void *)this);
         // Lic callback
         OMlic_set_err_callback( (void *)gmod_err_handler_func, (void *)this);
      }
      _enabled = enabled;
   }

   // return 1 for success
   return(1);
}

int
GMOD_err_handler::deinstance(OMevent_mask, // event_mask
                             int)          // seq_num
{
   if (_enabled) {
      ERRpop_error_dlg(gmod_err_handler_func);
      _enabled = 0;
   }

   // return 1 for success
   return(1);
}

// Due to CFS 9423, we cannot count on the deinstance method
// being called at the right time, thus we introduce an
// explicit destructor to fix CFS 25121.
GMOD_err_handler::~GMOD_err_handler()
{
   if (_enabled) {
      ERRpop_error_dlg(gmod_err_handler_func);
      _enabled = 0;
   }
}
