/*
			Copyright (c) 1993 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/gmod/execcomm.c#1 $
*/

#define XP_WIDE_API	/* Use Wide APIs */

#include <ctype.h>
#include <avs/util.h>
#include <avs/om.h>
#ifdef USE_UNIX
#include <signal.h>
#endif

#define EXCO_VARIABLE_CHAR '@'
#define EXCO_MAX_VARS 16
#define EXCO_MAX_VAR_SIZE 128
#define EXCO_BUFFER_SIZE   8192

#ifdef USE_UNIX
void (*om_signal(int sig, void (*func)())) (int);
#endif

#if defined(SIGCHLD) && !defined(SIGCLD)
#define SIGCLD SIGCHLD
#endif

#ifdef WIN32
#include <fcntl.h>
#include <process.h>
#endif

/* 64-bit porting. Only Modified Internally */
int
GMODshell_command(OMobj_id obj_id, OMevent_mask mask, int seq_num)
{
   OMobj_id comm_id = OMfind_subobj(obj_id,OMstr_to_name("command"),
				     OM_OBJ_RD);
   char *comm_value;
   int j, o, v;
   char *c, *str, str_buf[256];
   char var_buf[256], buf1[128];
   char *cbuf;
   int err;
   OMobj_id var_id, out_id;
   FILE *fp;
   char *ptr, *cptr;
   xp_long size, curr_size;
   int active, on_inst;
   void (*oldsig)();
   int output_string;

   /*
    * Allow this to be deactivated so that the user can change the command
    * without having the command run right away.
    */
   if (OMget_name_int_val(obj_id, OMstr_to_name("active"), &active) == 1 &&
       active == 0)
      return(1);

   /*
    * If we are being woken up by an instance event, we don't execute
    * if the on_inst flag is not set.
    */
   if ((mask & OM_EVENT_INST) &&
	OMget_name_int_val(obj_id, OMstr_to_name("on_inst"), &on_inst) == 1
	&& on_inst == 0)
      return(1);

   if (OMget_str_val(comm_id, &comm_value, 0) != 1)
      return(0);

   /*
    * We need to replace any variables specified in the "command string".
    */
   ALLOCN(cbuf, char, strlen(comm_value) +
	  EXCO_MAX_VARS * EXCO_MAX_VAR_SIZE,
	  "can't allocate output command buffer");
   err = 0;
   for (o = 0, c = comm_value; *c != '\0'; c++) {
      if (*c == EXCO_VARIABLE_CHAR) {
	 for (v = 0, c++; isalpha(*c) || isdigit(*c) ||
			  *c == '#' || *c == '_' || *c == '.' ||
			  *c == '[' || *c == ']' || *c == '<' ||
			  *c == '-'; c++) {
	    var_buf[v++] = *c;
	 }
	 var_buf[v] = '\0';

	 var_id = OMfind_str_subobj(obj_id, var_buf, OM_OBJ_RD);
	 str = str_buf;
	 if (OMis_null_obj(var_id)) {
	    ERRerror("GMODshell_command",2,ERR_ORIG,
	     "unable to find command variable object: %s for obj: %s",var_buf,
	     OMret_obj_path(obj_id,buf1,sizeof(buf1)));
	    err = 1;
	 }
	 else if (OMget_str_val(var_id,&str,sizeof(str_buf)) != 1) {
	    ERRerror("GMODshell_command",2,ERR_ORIG,
	     "no value for command variable: %s for obj: %s",var_buf,
	     OMret_obj_path(obj_id,buf1,sizeof(buf1)));
	    err = 1;
	 }
	 else {
	    for (j = 0; j < (int)strlen(str); j++) {
	       cbuf[o++] = str[j];
	    }
	    cbuf[o++] = ' ';
	 }
	 /*
	  * If we missed our exit condition, get out.
	  */
	 if (*c == '\0') break;
      }
      else cbuf[o++] = *c;
   }
   cbuf[o++] = '\0';

#ifdef USE_UNIX
   oldsig = om_signal(SIGCLD, SIG_DFL);
#endif
   /*
    * Only return after we've generated all errors that we might generate
    * so that the user doesn't have to go through this one by one...
    */

#ifdef WIN32
   {
     /*
	   Haven't got _popen to work. Nevermind, we can Win32 implement this.
     */
      SECURITY_ATTRIBUTES sa          = {0};
      STARTUPINFO         si          = {0};
      PROCESS_INFORMATION pi          = {0};
      HANDLE              hPipeWrite  = NULL;
      HANDLE              hPipeRead   = NULL;
      CHAR Buffer[256];

      sa.nLength = sizeof(sa);
      sa.bInheritHandle = TRUE;
      sa.lpSecurityDescriptor = NULL;


      /* Create pipe for output redirection. */
      CreatePipe(&hPipeRead,  /* read handle */
              &hPipeWrite, /* write handle */
              &sa,      /* security attributes */
              0      /* number of bytes reserved for pipe - 0 default */
              );

      /* Make child process use hPipeWrite as standard out */
      si.cb = sizeof(si);
      si.dwFlags     = STARTF_USESHOWWINDOW | STARTF_USESTDHANDLES;
      si.wShowWindow = SW_NORMAL;
      si.hStdInput   = GetStdHandle (STD_INPUT_HANDLE);
      si.hStdOutput  = hPipeWrite;
      si.hStdError   = hPipeWrite;

      CreateProcess (NULL,
            cbuf,
            NULL, NULL,
            TRUE, 0,
            NULL, NULL,
            &si, &pi);

       /* now that this has been inherited, close it to be safe.
          We don't want to write to it accidentally*/
      CloseHandle(hPipeWrite);

	  {
	   /*  try to open low level FILE descriptor at the Read end of pipe */
	   int fd = _open_osfhandle ( (long) hPipeRead, _O_RDONLY );
	   fp  = _fdopen(fd, "r");
	  }
   }


   if (err == 1 || fp == NULL) {

#else /* ifdef WIN32 */

   if (err == 1 || (fp = popen(cbuf, "r")) == NULL) {

#endif

      ERRerror("GMODshell_command",1,ERR_ORIG,
	       "can't execute command: %s\n",cbuf);
      FREE(cbuf);
      FREE(comm_value);

#ifdef USE_UNIX
      om_signal(SIGCLD, oldsig);
#endif
      return(0);
   }

   ALLOCN(ptr,char,EXCO_BUFFER_SIZE,"can't alloc command buffer");
   cptr = ptr;
   curr_size = 0;
   while ((size = fread(cptr,1,EXCO_BUFFER_SIZE,fp)) > 0) {
      curr_size += size;
      REALLOC(ptr,char,curr_size + EXCO_BUFFER_SIZE,
	      "can't realloc the output buffer");
      cptr = ptr + curr_size;
   }
   if (curr_size > 0) {
      /*
       * Shrink it down to the final size...
       */
      REALLOC(ptr,char,curr_size+1,"can't realloc output buffer");
      /*
       * NULL teminate for treating this as a string
       */
      ptr[curr_size] = '\0';
   }
   else {
      FREE(ptr);
      ptr = NULL;
   }

   pclose(fp);

#ifdef USE_UNIX
   om_signal(SIGCLD, oldsig);
#endif

   FREE(comm_value);
   FREE(cbuf);

   /*
    * Outputing this only as a char array is not too useful until we
    * get the conversion mechanism in place.  Until then, output as
    * a string as well
    */
   if (OMget_name_int_val(obj_id, OMstr_to_name("output_string"),
	 		  &output_string) == 1 && output_string)
      OMset_name_str_val(obj_id, OMstr_to_name("stdout_string"), ptr);

   out_id = OMfind_subobj(obj_id, OMstr_to_name("stdout"), OM_OBJ_RW);
   OMset_array(out_id,OM_TYPE_CHAR,ptr,curr_size,OM_SET_ARRAY_FREE);

   return(1);
}
