/*
			Copyright (c) 2003 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/gmod/greverse.c#1 $
*/

#define XP_WIDE_API	/* Use Wide APIs */

#include <avs/om.h>
#include <avs/err.h>

/*
 * Given an array of groups, make a new array in reverse order.
 */
/* 64-bit porting. Only Modified Internally */
int
GMODgroup_reverse_update(OMobj_id obj_id, OMevent_mask event_mask, int seq_num)
{
    int in_ints_size;
    xp_long i, j, dims[1];
    OMobj_id in_group_id, referencing_object, referenced_object;
    int status;

    /*
     * handle to input list
     */
    in_group_id = OMfind_subobj( obj_id, OMstr_to_name("in_groups"),
                                 OM_OBJ_RD );

    /*
     * get array length
     */
    status = OMget_array_dims( in_group_id, &in_ints_size, dims );
    if( status != OM_STAT_SUCCESS ) {
        ERRverror("GMODgroup_reverse", ERR_ORIG,
                  "Invalid input array of groups" );
        return 0;
    }
    j = dims[0];
    if( j <= 0 ) {
        ERRverror( "GMODgroup_reverse", ERR_ORIG,
                   "Input array of groups is zero length" );
        return 0;
    }

    /*
     * handle to output list
     */
    referencing_object = OMfind_subobj( obj_id, OMstr_to_name("out_groups"),
                                        OM_OBJ_RW );

    /*
     * reset, clean out the output array
     */
    status = OMset_obj_ref( referencing_object, OMnull_obj, 0 );
    if( status != OM_STAT_SUCCESS ) {
        ERRverror( "GMODgroup_reverse", ERR_ORIG, "Cannot reset out_groups");
        return 0;
    }

    /*
     * loop over values, set output values in opposite order
     */
    for( i=j-1; i >= 0; --i ) {
        /*
         * get input reference starting at the end
         */
        status = OMget_array_val( in_group_id, i, &referenced_object,
                                  OM_OBJ_RD );
        if( status != OM_STAT_SUCCESS ) {
            ERRverror("GMODgroup_reverse", ERR_ORIG,
                      "Cannot access in_groups[%d]", i );
            return 0;
        }

        /*
         * set output, adding in forward order
         */
        status = OMadd_obj_ref( referencing_object, referenced_object, 0 );
        if( status != OM_STAT_SUCCESS ) {
            ERRverror( "GMODgroup_reverse", ERR_ORIG,
                "Cannot add reference from out_groups to in_groups[%d]", i );
            return 0;
        }
    }

    return 1;
}
