/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/gmod/ldscrrel.c#1 $
*/

#define XP_WIDE_API	/* Use Wide APIs */

#include <stdio.h>
#include <avs/om.h>
#include <avs/util.h>

int GMODload_script(OMobj_id obj_id, OMevent_mask mask, int seq_num)
{
   OMobj_id file_id, rel_id, inst_obj, rel_obj;
   char val_buf[1024];
   char *file = val_buf;
   int active, on_inst;
   int tmp, replace;

   /*
    * Allow this to be deactivated so that the user can change the command
    * without having the command run right away.
    */
   if (OMget_name_int_val(obj_id, OMstr_to_name("active"), &active) == 1 &&
       active == 0)
      return(1);

   /*
    * If we are being woken up by an instance event, we don't execute
    * if the on_inst flag is not set.
    */
   if ((mask & OM_EVENT_INST) &&
	OMget_name_int_val(obj_id, OMstr_to_name("on_inst"), &on_inst) == 1
	&& on_inst == 0)
      return(1);

   if (OMget_name_int_val(obj_id, OMstr_to_name("replace"), &replace) != 1)
      replace = 1;

   file_id = OMfind_subobj(obj_id, OMstr_to_name("filename"), OM_OBJ_RD);
   if (OMget_str_val(file_id, &file, sizeof(val_buf)) != 1) {
      fprintf(stderr, "[load_script]: Unable to get filename string\n");
      return(0);
   }

   rel_id = OMfind_subobj(obj_id, OMstr_to_name("relative"), OM_OBJ_RD);
   if (OMget_obj_val(rel_id, &rel_obj) == 1)
     inst_obj = rel_obj;
   else
     inst_obj = OMinst_obj;

   /* Mark the stuff in the script as transient so if we
      happen to be recording, we won't log any of the events.
      The fact that we loaded the file is good enough - else
      we will get everything twice.
   */
   OMpush_ctx(obj_id, 0, 0, 0);

   /*
    * This will suppress the journalling of the read_desc operation itself.
    * presumably the operation that triggers us to run will be journalled
    * and thus it will be replayed properly
    */
   OMstart_journal_op(NULL,&tmp);

   OMread_desc(inst_obj,file,replace ? 0 : OM_READ_UNIQ);

   OMend_journal_op(&tmp);

   OMpop_ctx(obj_id);

   return(1);
}

int GMODparse_v(OMobj_id obj_id, OMevent_mask mask, int seq_num)
{
   OMobj_id buff_id, rel_id, mode_id, inst_obj, rel_obj;
   char *buff_ptr = NULL;
   int mode, no_errors;
   int active, on_inst;

   /*
    * Allow this to be deactivated so that the user can change the command
    * without having the command run right away.
    */
   if (OMget_name_int_val(obj_id, OMstr_to_name("active"), &active) == 1 &&
       active == 0)
      return(1);

   /*
    * If we are being woken up by an instance event, we don't execute
    * if the on_inst flag is not set.
    */
   if (mask == OM_EVENT_INST &&
	OMget_name_int_val(obj_id, OMstr_to_name("on_inst"), &on_inst) == 1
	&& on_inst == 0)
      return(1);

   /*
    * v command buffer
    */
   buff_id = OMfind_subobj(obj_id, OMstr_to_name("v_commands"), OM_OBJ_RD);
   if (OMget_str_val(buff_id, &buff_ptr, 0) != 1) {
      fprintf(stderr, "[parse_v]: Unable to find v_commands to parse\n");
      return(0);
   }

   /*
    * relative to path
    */
   rel_id = OMfind_subobj(obj_id, OMstr_to_name("relative"), OM_OBJ_RD);
   if (OMget_obj_val(rel_id, &rel_obj) == 1)
     inst_obj = rel_obj;
   else
     inst_obj = OMinst_obj;

   /*
    * mode:
    *   If mode is 0, push-parse_whole_string-pop.
    *   If mode is 1, repeat:push-parse_each_line-pop.
    */
   mode_id = OMfind_subobj(obj_id, OMstr_to_name("mode"), OM_OBJ_RD);
   if (OMget_int_val(mode_id, &mode) != 1)
     mode = 0;

   if (OMget_name_int_val(obj_id, OMstr_to_name("no_errors"), &no_errors) != 1)
      no_errors = 0;

   if (buff_ptr == NULL)
     return(1);

   /*
    * mode is 0, push-parse_whole_string-pop.
    */
   if (mode == 0) {
      int sync;
      if (OMget_name_int_val(obj_id, OMstr_to_name("sync"), &sync) != 1)
	 sync = 0;
      OMpush_ctx(obj_id, OM_STATE_TRANSIENT,
		 sync == 0 ? OM_CTX_PARENT_NOTIFIES : 0,
		 OM_CTX_INHERIT_STATE_MODE);

      /*
       * Set up how we should handle errors... either squash them or say where
       * they are coming from!
       */
      if (no_errors) {
	 ERRsquash_start();
      }
      else {
	 char err_buf[256], buf1[64];
	 sprintf(err_buf,"parse_v obj: %s",
		 OMret_obj_path_to(obj_id, OMinst_obj, buf1, sizeof(buf1), 0));
	 ERRpush_error_ctx(NULL,err_buf,NULL);
      }

      OMparse_buffer(inst_obj,buff_ptr,0);

      if (no_errors) {
	  ERRsquash_end();
      }
      else ERRpop_error_ctx(NULL, NULL);

      OMpop_ctx(obj_id);
   }
   /*
    * mode is 1, repeat:push-parse_each_line-pop.
    */
   else {
     int n;
     char *s, *c, *p, buf[256];

     n = (int)strlen(buff_ptr) + 1;

     if (!(s = (char *)malloc(n))) {
       fprintf(stderr, "[parse_v]: can't malloc %d bytes\n", n);
       exit(1);
     }
     strcpy(s, buff_ptr);

     p = s;

     while (*p) {
       /* No more delimiters */
       if (!(c = strchr(p, ';')))
	 break;

       *c = '\0';

       if (*p) {
	 sprintf(buf, "%s;", p);

	 OMpush_ctx(obj_id, OM_STATE_TRANSIENT, 0, OM_CTX_INHERIT_STATE_MODE);
	 OMparse_buffer(inst_obj,buf,0);
	 OMpop_ctx(obj_id);

	 p = c + 1;
       }
     }
     free(s);
   }
   FREE(buff_ptr);

   return(1);
}

int
GMODcopy_on_change(OMobj_id obj_id, OMevent_mask mask, int seq_num)
{
   OMobj_id input, output;
   int on_inst;

   /*
    * If we are being woken up by an instance event, we don't execute
    * if the on_inst flag is not set.
    */
   if ((mask & OM_EVENT_INST) &&
	OMget_name_int_val(obj_id, OMstr_to_name("on_inst"), &on_inst) == 1
	&& on_inst == 0)
      return(1);

   input = OMfind_subobj(obj_id, OMstr_to_name("input"), OM_OBJ_RW);
   output = OMfind_subobj(obj_id, OMstr_to_name("output"), OM_OBJ_RW);

   (void) OMset_obj_val(output,input,0);

   return(1);
}
