/*
			Copyright (c) 1995 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/gmod/sel_arr.c#1 $
*/

#define XP_WIDE_API	/* Use Wide APIs */

#include <avs/om.h>


/*
module select_array {
   int+notify+read select[];
   group+notify+read *array_input[];
   group+write *array_output[];
   omethod+notify_inst update = "GMODselect_array";
};
*/


int
GMODselect_array(OMobj_id obj_id, OMevent_mask event_mask, int seq_num)
{
   OMobj_id out_id, in_id, in_val;
   int *sel_array;
   xp_long size, i;

   in_id = OMfind_subobj(obj_id, OMstr_to_name("array_input"), OM_OBJ_RW);
   out_id = OMfind_subobj(obj_id, OMstr_to_name("array_output"), OM_OBJ_RW);
   /*
    * Start out with nothing on the output
    */
   OMset_obj_val(out_id, OMnull_obj, 0);

   sel_array = (int *)OMret_name_array_ptr(obj_id, OMstr_to_name("select"),
				    OM_GET_ARRAY_RD, &size, NULL);

   if (sel_array == NULL) size = 0;

   for (i = 0; i < size; i++) {
      if (OMget_array_val(in_id, i, &in_val, OM_OBJ_RW) != 1)
	 continue;
      /*
       * Only output the selected entries
       */
      if (sel_array[i]) {
	 if (OMget_obj_val(in_val, &in_val) != 1) continue;
         OMadd_array_val(out_id, in_val);
      }
   }
   if (sel_array) ARRfree(sel_array);
   return(1);
}
