/*
			Copyright (c) 1995 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/gmod/sel_ind.c#1 $
*/

#define XP_WIDE_API	/* Use Wide APIs */

#include <avs/om.h>


/*
   The selected_index module assigns as its output the index of the
   first nonzero element of its input array.

   module selected_index {
      boolean+notify+read select[];
      long+write output;
      omethod+notify_inst update = "GMODselected_index";
   };
*/

/* 64-bit porting. Only Modified Internally */
int
GMODselected_index(OMobj_id obj_id, OMevent_mask event_mask, int seq_num)
{
   int *sel_array;
   xp_long i, size;

   sel_array = (int *)OMret_name_array_ptr(obj_id, OMstr_to_name("select"),
				    OM_GET_ARRAY_RD, &size, NULL);

   if (sel_array == NULL) size = 0;

   for (i = 0; i < size; i++) {
      if (sel_array[i]) {
         OMset_name_long_val(obj_id, OMstr_to_name("output"), i);
         break;
      }
   }

   if (sel_array) ARRfree(sel_array);
   return(1);
}
