/*
//
//                      Copyright (c) 1996 by
//                      Advanced Visual Systems Inc.
//                      All Rights Reserved
//
//      This software comprises unpublished confidential information of
//      Advanced Visual Systems Inc. and may not be used, copied or made
//      available to anyone, except in accordance with the license
//      under which it is furnished.
//
//      $Id: //depot/express/fcs70/include/agx/agx64.h#1 $
//
// UNIRAS function declarations for IMA
//--------------------------------------------------------------------*/

#ifndef _agx32_h
#ifndef _agx64_h
#define _agx64_h

#ifndef WIN32
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#else
#include <windows.h>
#endif

#ifndef NeedFunctionPrototypes
#if defined(FUNCPROTO) || defined(__STDC__) || defined(__cplusplus)
#define NeedFunctionPrototypes 1
#else
#define NeedFunctionPrototypes 0
#endif
#endif                                         /* NeedFunctionPrototypes */

#ifndef NeedWidePrototypes
#if defined(NARROWPROTO)
#define NeedWidePrototypes 0
#else
#define NeedWidePrototypes 1        /* default to make interropt. easier */
#endif
#endif

#ifdef __cplusplus                  /* do not leave open across includes */
extern "C" {                                            /* for C++ V2.0 */
#endif

/*
 *  Set version defines
  */
#define XuVERSION_STRING "AVS/UNIRAS TOOLMASTER - agX Version 7V1"
#define XuVERSION         7
#define XuREVISION        1
#define XuUPDATE_LEVEL   ' '
#define XuVersion        (XuVERSION*1000 + XuREVISION*100 + XuUPDATE_LEVEL)

/*
 *  Set some test defines
 */
#define AGX_6V3B  (6*1000 + 3*100 + 'B')
#define AGX_6V4A  (6*1000 + 4*100 + 'A')
#define AGX_6V4B  (6*1000 + 4*100 + 'B')
#define AGX_6V5A  (6*1000 + 5*100 + 'A')
#define AGX_7V0   (7*1000 + 0*100 + ' ')
#define AGX_7V1   (7*1000 + 1*100 + ' ')                                      

/* 
 * Set return state definitions
 */
#define XuOK 0
#define XuWARNING 1
#define XuERROR 2
#define XuFATAL 3

#ifndef XuCallCnv
#ifndef WIN32
#define XuCallCnv
#else
// We are currently using an version of the agX library compiled with
// MSDEV 6 (_MSC_VER==1200), so using this header file while compiling 
// Express with MSDEV 7 (MSC_VER==1300) leads to link errors.
#if _MSC_VER >= 1300
#define XuCallCnv
#else
#define XuCallCnv __stdcall
#endif
#endif
#endif

/* Define XuType */
#ifndef XuType
#define XuType void
#endif
                       
/* Define XuFloat */

#define _XuFloat
typedef double XuFloat;

/*
 * XuOpenAdvanced options
 */
#ifndef WIN32
typedef struct {
  int colormodel;
  int colors;
  int depth;
  Colormap cmap;
  Visual* visual;
  XStandardColormap* stdcmap;
  int subtractive;
  Screen* screen;
} XuAdvancedOptions;
#else              
typedef struct {
  int colormodel;
  int colors;
  int depth;
  void *cmap;
  void *visual;
  void *stdcmap;
  int subtractive;
  void *screen;
} XuAdvancedOptions;
#endif                                                                     

/* Define 32 - 64 bit name map for functions using float pointers */

#define XuAxisLimitsQuery                XuAxisLimitsQuery_d             
#define XuAxisPlanesQuery                XuAxisPlanesQuery_d             
#define XuAxisPlanesSetQuery             XuAxisPlanesSetQuery_d          
#define XuAxisPolarLengthQuery           XuAxisPolarLengthQuery_d        
#define XuAxisPolarLimitsQuery           XuAxisPolarLimitsQuery_d        
#define XuAxisPolarPolygonsQuery         XuAxisPolarPolygonsQuery_d      
#define XuAxisPolarToWorld               XuAxisPolarToWorld_d            
#define XuAxisPolarWorldToPolar          XuAxisPolarWorldToPolar_d       
#define XuAxisPolygonsQuery              XuAxisPolygonsQuery_d           
#define XuAxisScaleUser                  XuAxisScaleUser_d               
#define XuAxisTimePolygonsQuery          XuAxisTimePolygonsQuery_d       
#define XuAxisTimesDatesToWorld3D        XuAxisTimesDatesToWorld3D_d     
#define XuAxisTimesDatesToWorld          XuAxisTimesDatesToWorld_d       
#define XuAxisTimesToWorld3D             XuAxisTimesToWorld3D_d          
#define XuAxisTimesToWorld               XuAxisTimesToWorld_d            
#define XuAxisUserPolygonsQuery          XuAxisUserPolygonsQuery_d       
#define XuAxisUserScaleUser              XuAxisUserScaleUser_d           
#define XuAxisWorld3DToTimesDates        XuAxisWorld3DToTimesDates_d     
#define XuAxisWorld3DToTimes             XuAxisWorld3DToTimes_d          
#define XuAxisWorldToTimesDates          XuAxisWorldToTimesDates_d       
#define XuAxisWorldToTimes               XuAxisWorldToTimes_d            
#define XuBlockContourDraw               XuBlockContourDraw_d            
#define XuBlockDraw                      XuBlockDraw_d                   
#define XuBlockIrr4DDraw                 XuBlockIrr4DDraw_d              
#define XuBlockIrrDraw                   XuBlockIrrDraw_d                
#define XuBlockIsolineDraw               XuBlockIsolineDraw_d            
#define XuCGMValueConvert                XuCGMValueConvert_d             
#define XuBarLinesDraw                   XuBarLinesDraw_d                
#define XuBars3DDraw                     XuBars3DDraw_d                  
#define XuBarsDraw                       XuBarsDraw_d                    
#define XuBarsIrr3DDraw                  XuBarsIrr3DDraw_d               
#define XuBarsVariableWidthDraw          XuBarsVariableWidthDraw_d       
#define XuChartArrow3DDraw               XuChartArrow3DDraw_d            
#define XuChartPolygonsDataFloatQuery    XuChartPolygonsDataFloatQuery_d 
#define XuChartPolygonsQuery             XuChartPolygonsQuery_d          
#define XuChartPolynomialFitCalc         XuChartPolynomialFitCalc_d      
#define XuChartSpline2DCalc              XuChartSpline2DCalc_d           
#define XuChartSplineCalc                XuChartSplineCalc_d             
#define XuChartSplineSmoothCalc          XuChartSplineSmoothCalc_d       
#define XuChartUndefInterval             XuChartUndefInterval_d          
#define XuChartXDataGet                  XuChartXDataGet_d               
#define XuChartXDataIrr                  XuChartXDataIrr_d               
#define XuChartXDataMerge                XuChartXDataMerge_d             
#define XuChartXDataRegInsert            XuChartXDataRegInsert_d         
#define XuCurve3DDraw                    XuCurve3DDraw_d                 
#define XuCurveDraw                      XuCurveDraw_d                   
#define XuCurveFillDraw                  XuCurveFillDraw_d               
#define XuCurveFillSteppedDraw           XuCurveFillSteppedDraw_d        
#define XuCurveSteppedDraw               XuCurveSteppedDraw_d            
#define XuLog10Calc                      XuLog10Calc_d                   
#define XuPieDraw                        XuPieDraw_d                     
#define XuPieLabelUserBoxQuery           XuPieLabelUserBoxQuery_d        
#define XuScatter3DDraw                  XuScatter3DDraw_d               
#define XuScatterDraw                    XuScatterDraw_d                 
#define XuContour3DDraw                  XuContour3DDraw_d               
#define XuContour4DDraw                  XuContour4DDraw_d               
#define XuContourDraw                    XuContourDraw_d                 
#define XuContourQuickDraw               XuContourQuickDraw_d            
#define XuIsoline3DDraw                  XuIsoline3DDraw_d               
#define XuIsoline4DDraw                  XuIsoline4DDraw_d               
#define XuIsolineDraw                    XuIsolineDraw_d                 
#define XuIsolineLabelHeight             XuIsolineLabelHeight_d          
#define XuIsolineTickColors              XuIsolineTickColors_d           
#define XuIsolineTickSymbols             XuIsolineTickSymbols_d          
#define XuIsolineTickWidths              XuIsolineTickWidths_d           
#define XuMapAreaDraw                    XuMapAreaDraw_d                 
#define XuMapPolygonDraw                 XuMapPolygonDraw_d              
#define XuContourUserDraw                XuContourUserDraw_d             
#define XuFaultCreate                    XuFaultCreate_d                 
#define XuIsolineUserDraw                XuIsolineUserDraw_d             
#define XuRegionChange                   XuRegionChange_d                
#define XuRegionCoordinateQuery          XuRegionCoordinateQuery_d       
#define XuRegionCreate                   XuRegionCreate_d                
#define XuVariableGridNodesCreate        XuVariableGridNodesCreate_d     
#define XuSymbolAttrHigh                 XuSymbolAttrHigh_d              
#define XuSymbolAttrLow                  XuSymbolAttrLow_d               
#define XuSymbolAttrUndefined            XuSymbolAttrUndefined_d         
#define XuSymbolIrrDraw                  XuSymbolIrrDraw_d               
#define XuSymbolPolygonsDataFloatQ       XuSymbolPolygonsDataFloatQ_d    
#define XuSymbolPolygonsQuery            XuSymbolPolygonsQuery_d         
#define XuSymbolRegDraw                  XuSymbolRegDraw_d               
#define XuArrowBoxQuery                  XuArrowBoxQuery_d               
#define XuCGMGenMetafileDescriptorGet    XuCGMGenMetafileDescriptorGet_d 
#define XuCGMGenPictureDescriptorGet     XuCGMGenPictureDescriptorGet_d  
#define XuCGMGenPictureDescriptor        XuCGMGenPictureDescriptor_d     
#define XuClassesCalc                    XuClassesCalc_d                 
#define XuClassesPercentiles             XuClassesPercentiles_d          
#define XuClassesQuery                   XuClassesQuery_d                
#define XuClasses                        XuClasses_d                     
#define XuColorOfPen                     XuColorOfPen_d                  
#define XuColorQuery                     XuColorQuery_d                  
#define XuColorTableQuery                XuColorTableQuery_d             
#define XuColor                          XuColor_d                       
#define XuCoordinatesReduce              XuCoordinatesReduce_d           
#define XuDeviceAttributesQuery          XuDeviceAttributesQuery_d       
#define XuDotsDraw                       XuDotsDraw_d                    
#define XuDrawingAreaQuery               XuDrawingAreaQuery_d            
#define XuHitPolygonComplexQuery         XuHitPolygonComplexQuery_d      
#define XuHitPolygonSimpleQuery          XuHitPolygonSimpleQuery_d       
#define XuIsolineWidths                  XuIsolineWidths_d               
#define XuLineDraw                       XuLineDraw_d                    
#define XuLogoScan                       XuLogoScan_d                    
#define XuMapPolygonsDataFloatQuery      XuMapPolygonsDataFloatQuery_d   
#define XuMapPolygonsQuery               XuMapPolygonsQuery_d            
#define XuPolygonDraw                    XuPolygonDraw_d                 
#define XuPolygonsDataFloatQuery         XuPolygonsDataFloatQuery_d      
#define XuPolygonShadeDraw               XuPolygonShadeDraw_d            
#define XuPolygonsQuery                  XuPolygonsQuery_d               
#define XuShadingLegendSizeQuery         XuShadingLegendSizeQuery_d      
#define XuShadingScaleChange             XuShadingScaleChange_d          
#define XuTextBoxCLDQuery                XuTextBoxCLDQuery_d             
#define XuTextBoxFloatQuery              XuTextBoxFloatQuery_d           
#define XuTextBoxISOQuery                XuTextBoxISOQuery_d             
#define XuTextBoxQuery                   XuTextBoxQuery_d                
#define XuTextContinueQuery              XuTextContinueQuery_d           
#define XuUndefinedQuery                 XuUndefinedQuery_d              
#define XuUPIHeader                      XuUPIHeader_d                   
#define XuViewAngleQuery                 XuViewAngleQuery_d              
#define XuViewDistanceQuery              XuViewDistanceQuery_d           
#define XuViewFocusPointQuery            XuViewFocusPointQuery_d         
#define XuViewMMToWorld                  XuViewMMToWorld_d               
#define XuViewObliqueQuery               XuViewObliqueQuery_d            
#define XuViewPCToWorld                  XuViewPCToWorld_d               
#define XuViewPixelToWorld               XuViewPixelToWorld_d            
#define XuViewPointPolarQuery            XuViewPointPolarQuery_d         
#define XuViewPointQuery                 XuViewPointQuery_d              
#define XuViewportQuery                  XuViewportQuery_d               
#define XuViewWallQuery                  XuViewWallQuery_d               
#define XuViewWorkboxQuery               XuViewWorkboxQuery_d            
#define XuViewWorld3DTo2D                XuViewWorld3DTo2D_d             
#define XuViewWorldLimitsQuery           XuViewWorldLimitsQuery_d        
#define XuViewWorldToMM                  XuViewWorldToMM_d               
#define XuViewWorldToPC                  XuViewWorldToPC_d               
#define XuViewWorldToPixel               XuViewWorldToPixel_d            
#define XuGrid3DDraw                     XuGrid3DDraw_d                  
#define XuGrid4DDraw                     XuGrid4DDraw_d                  
#define XuGridDraw                       XuGridDraw_d                    
#define XuGridIrr3DDraw                  XuGridIrr3DDraw_d               
#define XuGridIrr4DDraw                  XuGridIrr4DDraw_d               
#define XuGridIrrRectanglesDraw          XuGridIrrRectanglesDraw_d       
#define XuMapIrrDotsDraw                 XuMapIrrDotsDraw_d              
#define XuMapIrrSymbolsDraw              XuMapIrrSymbolsDraw_d           
#define XuScanFloatDraw                  XuScanFloatDraw_d               
#define XuGriddingFastLocalFitCalc       XuGriddingFastLocalFitCalc_d    
#define XuGriddingLeastSquaresCalc       XuGriddingLeastSquaresCalc_d    
#define XuGriddingLocalFitCalc           XuGriddingLocalFitCalc_d        
#define XuGriddingPartCalc               XuGriddingPartCalc_d            
#define XuGriddingThinPlateSplineCalc    XuGriddingThinPlateSplineCalc_d 
#define XuGriddingTriangulationCalc      XuGriddingTriangulationCalc_d   
#define XuGridResamplingCalc             XuGridResamplingCalc_d          
#define XuKriging2DCalc                  XuKriging2DCalc_d               
#define XuKriging2DPointCalc             XuKriging2DPointCalc_d          
#define XuKriging2DSemivarCalc           XuKriging2DSemivarCalc_d        
#define XuKriging2DUniversalCalc         XuKriging2DUniversalCalc_d      
#define XuKriging2DUniversalPointCalc    XuKriging2DUniversalPointCalc_d 
#define XuKriging3DCalc                  XuKriging3DCalc_d               
#define XuKriging3DPointCalc             XuKriging3DPointCalc_d          
#define XuKriging3DSemivarCalc           XuKriging3DSemivarCalc_d        
#define XuKrigingBenchCompositeCalc      XuKrigingBenchCompositeCalc_d   
#define XuKrigingBlockCalc               XuKrigingBlockCalc_d            
#define XuKrigingFault                   XuKrigingFault_d                
#define XuKrigingMeanCalc                XuKrigingMeanCalc_d             
#define XuKrigingRegionPolygon           XuKrigingRegionPolygon_d        
#define XuKrigingSemivarBlockCalc        XuKrigingSemivarBlockCalc_d     
#define XuKrigingSemivarDraw             XuKrigingSemivarDraw_d          
#define XuKrigingSphericalModel          XuKrigingSphericalModel_d       
#define XuUPICircle                      XuUPICircle_d                   
#define XuUPIClasses                     XuUPIClasses_d                  
#define XuUPIClip                        XuUPIClip_d                     
#define XuUPIColorTable                  XuUPIColorTable_d               
#define XuUPIColor                       XuUPIColor_d                    
#define XuUPIContour                     XuUPIContour_d                  
#define XuUPIDot                         XuUPIDot_d                      
#define XuUPIDrawingArea                 XuUPIDrawingArea_d              
#define XuUPIEllipse                     XuUPIEllipse_d                  
#define XuUPIGrid                        XuUPIGrid_d                     
#define XuUPILine                        XuUPILine_d                     
#define XuUPIPolygon                     XuUPIPolygon_d                  
#define XuUPIRectangle                   XuUPIRectangle_d                
#define XuUPIText                        XuUPIText_d                     
#define XuUPIUserData                    XuUPIUserData_d                 
#define XuWorldmapCountryGet             XuWorldmapCountryGet_d          
#define XuWorldmapLimitsQuery            XuWorldmapLimitsQuery_d         
#define XuProjPointsGet                  XuProjPointsGet_d               
#define XuProjSingle                     XuProjSingle_d                  
#define XuLightIntensityNormalsCalc      XuLightIntensityNormalsCalc_d   
#define XuLightIntensityXproductCalc     XuLightIntensityXproductCalc_d  
#define XuLightSourcePointQuery          XuLightSourcePointQuery_d       
#define XuLine3DDraw                     XuLine3DDraw_d                  
#define XuObjectLightPropertiesQuery     XuObjectLightPropertiesQuery_d  
#define XuPolygon3DDraw                  XuPolygon3DDraw_d               
#define XuPolygonList3DDraw              XuPolygonList3DDraw_d           
#define XuPolygonList3DLightDraw         XuPolygonList3DLightDraw_d      
#define XuShadingConstant                XuShadingConstant_d             
#define XuSeismicContourDraw             XuSeismicContourDraw_d          
#define XuSeismicDensityDraw             XuSeismicDensityDraw_d          
#define XuSeismicOriginQuery             XuSeismicOriginQuery_d          
#define XuSeismicSamplePositionQuery     XuSeismicSamplePositionQuery_d  
#define XuWiggleDraw                     XuWiggleDraw_d                  
#define XuVolumeClip                     XuVolumeClip_d                  
#define XuVolumeColor                    XuVolumeColor_d                 
#define XuVolumeCuttingPlanesDraw        XuVolumeCuttingPlanesDraw_d     
#define XuVolumeCuttingPlanes            XuVolumeCuttingPlanes_d         
#define XuVolumeDataMapping              XuVolumeDataMapping_d           
#define XuVolumeGridFromScatDataCalc     XuVolumeGridFromScatDataCalc_d  
#define XuVolumeIsoLevelSurfacesDraw     XuVolumeIsoLevelSurfacesDraw_d  
#define XuVolumeIsoLevels                XuVolumeIsoLevels_d             
#define XuVolumePointInterpolationC      XuVolumePointInterpolationC_d   
#define XuVolumeThresholdVolumeDraw      XuVolumeThresholdVolumeDraw_d   

/*                                                                       */
/* XuInitialize - Initialize UNIRAS                                      */
/*                                                                       */

extern XuType XuInitialize (
#if NeedFunctionPrototypes
/*                                                                       */
  int       argc     , /* i   in  \tts argc from main program            */
  char      **argv     /* c   in  \tts argv from main program            */
#endif
);

#ifdef WIN32
/*                                                                       */
/* XuTextUNICODEDraw - Draw UNICODE text                                 */
/*                                                                       */
extern XuType XuCallCnv XuTextUNICODEDraw (
#if NeedFunctionPrototypes
  wchar_t *str, 
  double x, 
  double y
#endif
);
/*                                                                       */
/* XuTextUNICODEContinueDraw - Draw UNICODE continuation text            */
/*                                                                       */
extern XuType XuCallCnv XuTextUNICODEContinueDraw(
#if NeedFunctionPrototypes
  wchar_t *str
#endif  
);
#endif

#ifdef __cplusplus
}                                                        /* for C++ V2.0 */
#endif

#endif /* _agx64_h */
#else
ERROR_Double_precision_version_agX_64_cannot_be_mixed_with_32_bit_version
#endif /* _agx32_h */
/* DON'T ADD ANYTHING AFTER THIS #endif */
