/*
//
//                      Copyright (c) 1996 by
//                      Advanced Visual Systems Inc.
//                      All Rights Reserved
//
//      This software comprises unpublished confidential information of
//      Advanced Visual Systems Inc. and may not be used, copied or made
//      available to anyone, except in accordance with the license
//      under which it is furnished.
//
//      This file is under CVS/RCS control in:
//      $Id: //depot/express/fcs70/include/agx/agxcgm.h#1 $
//
// UNIRAS function declarations for CGM
//--------------------------------------------------------------------*/

#ifndef _agxcgm_h
#define _agxcgm_h

#ifndef _agx64_h
#ifndef _agx32_h
#include <agX/agx32.h>
#endif
#endif

#ifndef NeedFunctionPrototypes
#if defined(FUNCPROTO) || defined(__STDC__) || defined(__cplusplus)
#define NeedFunctionPrototypes 1
#else
#define NeedFunctionPrototypes 0
#endif
#endif                                         /* NeedFunctionPrototypes */

#ifndef NeedWidePrototypes
#if defined(NARROWPROTO)
#define NeedWidePrototypes 0
#else
#define NeedWidePrototypes 1        /* default to make interropt. easier */
#endif
#endif

#ifdef __cplusplus                  /* do not leave open across includes */
extern "C" {                                            /* for C++ V2.0 */
#endif
/*                                                                       */
/* XuCGMElementApply - Apply CGM state changes                           */
/*                                                                       */
extern XuType XuCallCnv XuCGMElementApply (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *state_vector   , /* ia  io  Array to store state vector     */
  int       buffer_size     , /* i   in  Size of element buffer array    */
  int       *element_buffer   /* ia  in  Array containing element buffer    */
#endif
);
/*                                                                       */
/* XuCGMFileCreate - Open file for writing                               */
/*                                                                       */
extern XuType XuCallCnv XuCGMFileCreate (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *state_vector , /* ia  io  Array to store state vector       */
  int       state_size    , /* i   in  Size of state vector array        */
  int       encoding      , /* i   in  Encoding to be used               */
  char      *filename     , /* c   in  Pathname of file to be created    */
  int       *options        /* ia  in  Array of special options          */
#endif
);
/*                                                                       */
/* encoding: Character encoding                                          */
#ifndef XuCHARACTER
#define XuCHARACTER 2
#endif
/* encoding: Binary encoding                                             */
#ifndef XuBINARY
#define XuBINARY 3
#endif
/* encoding: Clear Text encoding                                         */
#ifndef XuCLEAR
#define XuCLEAR 4
#endif
/*                                                                       */
/*                                                                       */
/* XuCGMFileIdentify - Identify CGM encoding type                        */
/*                                                                       */
extern XuType XuCallCnv XuCGMFileIdentify (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *state_vector , /* ia  io  Array to store state vector       */
  int       state_size    , /* i   in  Size of state vector array        */
  int       *encoding     , /* i   out Encoding determined               */
  char      *filename     , /* c   in  Pathname of file to be read       */
  int       *options        /* ia  in  Array of special options          */
#endif
);
/*                                                                       */
/* XuCGMFileOpen - Open CGM file for read                                */
/*                                                                       */
extern XuType XuCallCnv XuCGMFileOpen (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *state_vector , /* ia  io  Array to store state vector       */
  int       state_size    , /* i   in  Size of state vector array        */
  int       encoding      , /* i   in  Encoding of CGM                   */
  char      *filename     , /* c   in  Pathname of file to be read       */
  int       *options        /* ia  in  Array of special options          */
#endif
);
/*                                                                       */
/* XuCGMElementRead - Read next element from CGM file                    */
/*                                                                       */
extern XuType XuCallCnv XuCGMElementRead (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *state_vector   , /* ia  io  Array to store state vector     */
  int       buffer_size     , /* i   in  Size of element buffer array    */
  int       *element_buffer , /* ia  out Array containing element buffer    */
  int       *buffer_used      /* i   out Size of element actually read    */
#endif
);
/*                                                                       */
/* XuCGMElementWrite - Write an element to CGM file                      */
/*                                                                       */
extern XuType XuCallCnv XuCGMElementWrite (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *state_vector   , /* ia  io  Array to store state vector     */
  int       buffer_size     , /* i   in  Size of element buffer array    */
  int       *element_buffer , /* ia  in  Array containing element buffer    */
  int       *buffer_used      /* i   out Size of element actually written    */
#endif
);
/*                                                                       */
/* XuCGMApplicationDataQuery - Get application data                      */
/*                                                                       */
extern XuType XuCallCnv XuCGMApplicationDataQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *id          , /* i   out Application Data identifier        */
  int       in_size      , /* i   in  Declared size of record            */
  int       *record      , /* ia  out Array containing escape data record    */
  int       *out_size    , /* i   out Number of elements returned in     */
  int       *error_state   /* ia  out Error indicators                   */
#endif
);
/*                                                                       */
/* XuCGMPictureBackground - Set picture background options               */
/*                                                                       */
extern XuType XuCallCnv XuCGMPictureBackground (
#if NeedFunctionPrototypes
/*                                                                       */
  int       clear_display  , /* i   in  Clear display surface indicator    */
  int       background       /* i   in  Picture background indicator     */
#endif
);
/*                                                                       */
/* clear_display: Do not clear surface                                   */
#ifndef XuOFF
#define XuOFF 0
#endif
/* clear_display: Clear surface                                          */
#ifndef XuON
#define XuON 1
#endif
/*                                                                       */
/*                                                                       */
/* XuCGMUserBreak - User defined break probing function for interpreter  */
/*                                                                       */
extern XuType XuCallCnv XuCGMUserBreak (
#if NeedFunctionPrototypes
/*                                                                       */
  int       userbrk    /* i   in  Address of user break probe function    */
#endif
);
/*                                                                       */
/* XuCGMElementCheck - Check CGM structure and element parameter         */
/*                                                                       */
extern XuType XuCallCnv XuCGMElementCheck (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *struct_check , /* i   out Structural error indicator        */
  int       *param_check  , /* i   io  Parameter error indicator         */
  int       *error_state    /* ia  out Error indicators                  */
#endif
);
/*                                                                       */
/* XuCGMValueConvert - Convert a normalised value according to the CGM s */
/*                                                                       */
extern XuType XuCallCnv XuCGMValueConvert (
#if NeedFunctionPrototypes
/*                                                                       */
  int       conversion  , /* i   in  Conversion type                     */
  void      *input      , /* ra  in  Input value                         */
  int       *output       /* ia  out Output value                        */
#endif
);
/*                                                                       */
/* conversion: RGB colour                                                */
#ifndef XuRGBCOLOR
#define XuRGBCOLOR 0
#endif
/* conversion: VDC point                                                 */
#ifndef XuVDCPOINT
#define XuVDCPOINT 1
#endif
/* conversion: Line width                                                */
#ifndef XuLINEWIDTH
#define XuLINEWIDTH 2
#endif
/* conversion: Marker size                                               */
#ifndef XuMARKERSIZE
#define XuMARKERSIZE 3
#endif
/* conversion: Edge width                                                */
#ifndef XuEDGEWIDTH
#define XuEDGEWIDTH 4
#endif
/*                                                                       */
/*                                                                       */
/* XuCGMColorQuery - Inquire color selection mode                        */
/*                                                                       */
extern XuType XuCallCnv XuCGMColorQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *color_mode  , /* i   out Colour selection mode              */
  int       *error_state   /* ia  out Error indicators                   */
#endif
);
/*                                                                       */
/* color_mode: Indexed mode                                              */
#ifndef XuINDEXED_MODE
#define XuINDEXED_MODE 0
#endif
/* color_mode: Direct mode                                               */
#ifndef XuDIRECT_MODE
#define XuDIRECT_MODE 1
#endif
/*                                                                       */
/*                                                                       */
/* XuCGMElementDelete - Delete the next element from interpreter stream  */
/*                                                                       */
extern XuType XuCallCnv XuCGMElementDelete (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *error_state   /* ia  out Error indicators                   */
#endif
);
/*                                                                       */
/* XuCGMDescriptionQuery - Read a CGM description                        */
/*                                                                       */
extern XuType XuCallCnv XuCGMDescriptionQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  char      *description , /* c   out Metafile description               */
  int       max_length   , /* i   in  Maximum length of string           */
  int       *error_state   /* ia  out Error indicators                   */
#endif
);
/*                                                                       */
/* XuCGMBlock2Draw - Interpret the elements of basic CGM element block   */
/*                                                                       */
extern XuType XuCallCnv XuCGMBlock2Draw (
#if NeedFunctionPrototypes
/*                                                                       */
  int       output       , /* i   in  Graphics output flag               */
  int       *reason      , /* i   out Reason for stopping                */
  int       *error_state   /* ia  out Error indicators                   */
#endif
);
/*                                                                       */
/* reason: End of file                                                   */
#ifndef XuENDOFFILE
#define XuENDOFFILE 0
#endif
/* reason: Metafile exited                                               */
#ifndef XuMETAFILE
#define XuMETAFILE 1
#endif
/* reason: Picture exited                                                */
#ifndef XuPICTURE
#define XuPICTURE 2
#endif
/* reason: Interruption                                                  */
#ifndef XuINTERRUPT
#define XuINTERRUPT 3
#endif
/*                                                                       */
/*                                                                       */
/* XuCGMSearchDraw - Interpret elements from CGM with a stop criterion   */
/*                                                                       */
extern XuType XuCallCnv XuCGMSearchDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  int       criterion    , /* i   in  Search criterion                   */
  int       *reason      , /* i   out Reason for stopping                */
  int       *error_state   /* ia  out Error indicators                   */
#endif
);
/*                                                                       */
/* criterion: Stop at next CGM                                           */
#ifndef XuBEGINCGM
#define XuBEGINCGM 1
#endif
/* criterion: Stop at next picture                                       */
#ifndef XuBEGINPICT
#define XuBEGINPICT 2
#endif
/* criterion: Stop at next CGM/picture                                   */
#ifndef XuBEGINANY
#define XuBEGINANY 3
#endif
/*                                                                       */
/*                                                                       */
/* XuCGMDisplayTransformation3 - Invoke Display Transformation           */
/*                                                                       */
extern XuType XuCallCnv XuCGMDisplayTransformation3 (
#if NeedFunctionPrototypes
/*                                                                       */
  double    offset_x  , /* r   in  X offset of the scaled output         */
  double    offset_y  , /* r   in  Y offset of the scaled output         */
  double    scale_xy    /* r   in  Isotropic scaling factor              */
#endif
);
/*                                                                       */
/* XuCGMDeviceViewport - Set device viewport                             */
/*                                                                       */
extern XuType XuCallCnv XuCGMDeviceViewport (
#if NeedFunctionPrototypes
/*                                                                       */
  double    lower_x  , /* r   in  Lower left x of viewport (mm)          */
  double    lower_y  , /* r   in  Lower left y of viewport (mm)          */
  double    upper_x  , /* r   in  Upper right x of viewport (mm)         */
  double    upper_y    /* r   in  Upper right y of viewport (mm)         */
#endif
);
/*                                                                       */
/* XuCGMExit - End the CGM system                                        */
/*                                                                       */
extern XuType XuCallCnv XuCGMExit (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *error_state   /* ia  out Error indicators                   */
#endif
);
/*                                                                       */
/* XuCGMEscapeDataQuery - Get escape data                                */
/*                                                                       */
extern XuType XuCallCnv XuCGMEscapeDataQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *id          , /* i   out Escape identifier                  */
  int       in_size      , /* i   in  Declared size of record            */
  int       *record      , /* ia  out Array containing escape data record    */
  int       *out_size    , /* i   out Number of elements returned in     */
  int       *error_state   /* ia  out Error indicators                   */
#endif
);
/*                                                                       */
/* XuCGMTranslateMessage - Translate an interpreter message code to text */
/*                                                                       */
extern XuType XuCallCnv XuCGMTranslateMessage (
#if NeedFunctionPrototypes
/*                                                                       */
  int       message     , /* i   in  Message number                      */
  char      *text       , /* c   out Interpreter message text            */
  int       max_length    /* i   in  Maximum length of text              */
#endif
);
/*                                                                       */
/* XuCGMMetafileNameQuery - Read a metafile name                         */
/*                                                                       */
extern XuType XuCallCnv XuCGMMetafileNameQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  char      *name        , /* c   out Metafile name                      */
  int       max_length   , /* i   in  Maximum length of string           */
  int       *error_state   /* ia  out Error indicators                   */
#endif
);
/*                                                                       */
/* XuCGMGDPQuery - Get Generalized Drawing Primitive points and data     */
/*                                                                       */
extern XuType XuCallCnv XuCGMGDPQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *id          , /* i   out \elemGDP identifier                */
  int       in_npts      , /* i   in  Declared size of points            */
  int       *points      , /* ia  out Array containing \elemGDP points data    */
  int       *out_npts    , /* i   out Number of points returned in       */
  int       in_size      , /* i   in  Declared size of record            */
  int       *record      , /* ia  out Array containing \elemGDP data record    */
  int       *out_size    , /* i   out Number of elements returned in     */
  int       *error_state   /* ia  out Error indicators                   */
#endif
);
/*                                                                       */
/* XuCGMElementExtract - Extracts current element from the CGM stream    */
/*                                                                       */
extern XuType XuCallCnv XuCGMElementExtract (
#if NeedFunctionPrototypes
/*                                                                       */
  int       maximum_index  , /* i   in  Maximum index for cgm_element    */
  int       *cgm_element   , /* ia  out \UNIRAS\ encoded element         */
  int       *error_state     /* ia  out Error indicators                 */
#endif
);
/*                                                                       */
/* XuCGMElementDraw - Interpret a CGM element                            */
/*                                                                       */
extern XuType XuCallCnv XuCGMElementDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *error_state   /* ia  out Error indicators                   */
#endif
);
/*                                                                       */
/* XuCGMUserLogging - Redirect an unnamed interpreter log to a user defi */
/*                                                                       */
extern XuType XuCallCnv XuCGMUserLogging (
#if NeedFunctionPrototypes
/*                                                                       */
  void      (*userlog)(char *)  /* vp  in  Address of user logging function    */
#endif
);
/*                                                                       */
/* XuCGMReverseBW - Reverse all instances of black and white             */
/*                                                                       */
extern XuType XuCallCnv XuCGMReverseBW (
#if NeedFunctionPrototypes
/*                                                                       */
  int       reverse    /* i   in  reverse flag                           */
#endif
);
/*                                                                       */
/* XuCGMSystemOpen - Open CGM system                                     */
/*                                                                       */
extern XuType XuCallCnv XuCGMSystemOpen (
#if NeedFunctionPrototypes
/*                                                                       */
  int       encoding      , /* i   in  Encoding type                     */
  int       element_size  , /* i   in  Maximum element size              */
  char      *filename     , /* c   in  Name of file to be read           */
  char      *profile      , /* c   in  Name of interpreter profile       */
  char      *error_file   , /* c   in  Name of error file                */
  int       *error_state    /* ia  out Error indicators                  */
#endif
);
/*                                                                       */
/* encoding: Encoding from profile                                       */
#ifndef XuCGMPROF
#define XuCGMPROF 0
#endif
/* encoding: Generic CGM                                                 */
#ifndef XuCGM
#define XuCGM 1
#endif
/*                                                                       */
/*                                                                       */
/* XuCGMElementInsert - Inserts an element into the CGM stream           */
/*                                                                       */
extern XuType XuCallCnv XuCGMElementInsert (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *element     , /* i   out Current element type               */
  int       *cgm_element , /* ia  in  \UNIRAS\ encoded element           */
  int       *error_state   /* ia  out Error indicators                   */
#endif
);
/*                                                                       */
/* XuCGMPictureNameQuery - Read a picture name                           */
/*                                                                       */
extern XuType XuCallCnv XuCGMPictureNameQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  char      *name        , /* c   out Picture name                       */
  int       max_length   , /* i   in  Maximum length of string           */
  int       *error_state   /* ia  out Error indicators                   */
#endif
);
/*                                                                       */
/* XuCGMProfileActiveQuery - Return current active CGM profile value for */
/*                                                                       */
extern XuType XuCallCnv XuCGMProfileActiveQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       profile_type  , /* i   in  Type of profile                   */
  char      *keyword      , /* c   in  Name of keyword                   */
  int       buffer_size   , /* i   in  Size of buffer                    */
  int       *buffer       , /* ia  out SDR containing active values      */
  int       *buffer_used  , /* i   out Size of buffer actually returned    */
  int       *error_value    /* i   out Error flag                        */
#endif
);
/*                                                                       */
/* profile_type: Interpretor profile                                     */
#ifndef XuCGMINT
#define XuCGMINT 0
#endif
/* profile_type: Generator profile                                       */
#ifndef XuCGMGEN
#define XuCGMGEN 1
#endif
/*                                                                       */
/*                                                                       */
/* XuCGMProfileDefaultQuery - Return CGM profile default value for given */
/*                                                                       */
extern XuType XuCallCnv XuCGMProfileDefaultQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       profile_type  , /* i   in  Type of profile                   */
  char      *keyword      , /* c   in  Name of keyword                   */
  int       buffer_size   , /* i   in  Size of buffer                    */
  int       *buffer       , /* ia  out SDR containing default values     */
  int       *buffer_used  , /* i   out Size of buffer actually returned    */
  int       *error_value    /* i   out Error flag (0 OK ;-1 Buffer overflow)    */
#endif
);
/*                                                                       */
/* XuCGMProfileSettingQuery - Return length of setting for given keyword */
/*                                                                       */
extern XuType XuCallCnv XuCGMProfileSettingQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       profile_type  , /* i   in  Type of profile                   */
  char      *keyword      , /* c   in  Name of keyword                   */
  int       *length       , /* i   out Length (No.) of currently set values    */
  int       *error_value    /* i   out Error flag (0 OK ;-1 Unknown keyword)    */
#endif
);
/*                                                                       */
/* XuCGMStateVectorQuery - Synthesizes an element from the interpreter s */
/*                                                                       */
extern XuType XuCallCnv XuCGMStateVectorQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       maximum_index  , /* i   in  Maximum index for cgm_element    */
  int       *cgm_element   , /* ia  io  \UNIRAS\ encoded element         */
  int       *error_state     /* ia  out Error indicators                 */
#endif
);
/*                                                                       */
/* XuCGMElementGet - Read a CGM element                                  */
/*                                                                       */
extern XuType XuCallCnv XuCGMElementGet (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *element     , /* i   out CGM element type                   */
  int       *eof         , /* i   out End of file indicator              */
  int       *error_state   /* ia  out Error indicators                   */
#endif
);
/*                                                                       */
/* XuCGMReset - Restore the fundamental graphics package status          */
/*                                                                       */
extern XuType XuCallCnv XuCGMReset (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *error_state   /* ia  out Error indicators                   */
#endif
);
/*                                                                       */
/* XuCGMRewind - Rewind the CGM file                                     */
/*                                                                       */
extern XuType XuCallCnv XuCGMRewind (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *error_state   /* ia  out Error indicators                   */
#endif
);
/*                                                                       */
/* XuCGMProfileActive - Set current active CGM profile value for given k */
/*                                                                       */
extern XuType XuCallCnv XuCGMProfileActive (
#if NeedFunctionPrototypes
/*                                                                       */
  int       profile_type  , /* i   in  Type of profile                   */
  int       buffer_size   , /* i   in  Size of buffer                    */
  int       *buffer       , /* ia  out SDR with values to be set         */
  int       *buffer_used  , /* i   out Size of buffer actually returned    */
  int       *error_value    /* i   out Error flag (0 - OK)               */
#endif
);
/*                                                                       */
/* XuCGMVDCQuery - Inquire VDC type                                      */
/*                                                                       */
extern XuType XuCallCnv XuCGMVDCQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *vdc_type    , /* i   out VDC type                           */
  int       *error_state   /* ia  out Error indicators                   */
#endif
);
/*                                                                       */
/* vdc_type: Integer VDC                                                 */
#ifndef XuINTEGER
#define XuINTEGER 0
#endif
/* vdc_type: Real VDC                                                    */
#ifndef XuREAL
#define XuREAL 1
#endif
/*                                                                       */
/*                                                                       */
/* XuCGMModesQuery - Inquire width/size specification modes              */
/*                                                                       */
extern XuType XuCallCnv XuCGMModesQuery (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *line_mode   , /* i   out Line width specification mode      */
  int       *marker_mode , /* i   out Marker size specification mode     */
  int       *edge_mode   , /* i   out Edge width specification mode      */
  int       *error_state   /* ia  out Error indicators                   */
#endif
);
/*                                                                       */
/* line_mode: Absolute mode                                              */
#ifndef XuABSOLUTE
#define XuABSOLUTE 0
#endif
/* line_mode: Scaled mode                                                */
#ifndef XuSCALED
#define XuSCALED 1
#endif
/*                                                                       */
/*                                                                       */
/* XuCGMGraphicsPackageClose - Close Fundamental Graphics Package        */
/*                                                                       */
extern XuType XuCallCnv XuCGMGraphicsPackageClose (
#if NeedFunctionPrototypes
#endif
);
/*                                                                       */
/* XuGraphicsPackageOpen - Open Fundamental Graphics Package             */
/*                                                                       */
extern XuType XuCallCnv XuGraphicsPackageOpen (
#if NeedFunctionPrototypes
#endif
);

#ifdef __cplusplus
}                                                        /* for C++ V2.0 */
#endif

#endif /* _agxcgm_h */
