/*
//
//                      Copyright (c) 1996 by
//                      Advanced Visual Systems Inc.
//                      All Rights Reserved
//
//      This software comprises unpublished confidential information of
//      Advanced Visual Systems Inc. and may not be used, copied or made
//      available to anyone, except in accordance with the license
//      under which it is furnished.
//
//      This file is under CVS/RCS control in:
//      $Id: //depot/express/fcs70/include/agx/agxcon.h#1 $
//
// UNIRAS function declarations for CON
//--------------------------------------------------------------------*/

#ifndef _agxcon_h
#define _agxcon_h

#ifndef _agx64_h
#ifndef _agx32_h
#include <agX/agx32.h>
#endif
#endif

#ifndef NeedFunctionPrototypes
#if defined(FUNCPROTO) || defined(__STDC__) || defined(__cplusplus)
#define NeedFunctionPrototypes 1
#else
#define NeedFunctionPrototypes 0
#endif
#endif                                         /* NeedFunctionPrototypes */

#ifndef NeedWidePrototypes
#if defined(NARROWPROTO)
#define NeedWidePrototypes 0
#else
#define NeedWidePrototypes 1        /* default to make interropt. easier */
#endif
#endif

#ifdef __cplusplus                  /* do not leave open across includes */
extern "C" {                                            /* for C++ V2.0 */
#endif
/*                                                                       */
/* XuMapAreaDraw - Draw area map                                         */
/*                                                                       */
extern XuType XuCallCnv XuMapAreaDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  void      *x_array    , /* ra  in  X-coordinates of polygon vertices    */
  void      *y_array    , /* ra  in  Y-coordinates of polygon vertices    */
  int       num_points  , /* i   in  Number of polygon vertices          */
  int       type_code     /* i   in  Type of display                     */
#endif
);
/*                                                                       */
/* type_code: 3D plinth                                                  */
#ifndef Xu3DPLINTH
#define Xu3DPLINTH -5
#endif
/* type_code: 2D plinth                                                  */
#ifndef Xu2DPLINTH
#define Xu2DPLINTH -3
#endif
/* type_code: 2D line 1 pixel thickness                                  */
#ifndef Xu2DFRAME
#define Xu2DFRAME 1
#endif
/* type_code: POL_BLACK 2 Black polygon (erase contours outside boundary */
#ifndef Xu2DPOL_BLACK
#define Xu2DPOL_BLACK 2
#endif
/* type_code: 2D polygon with a 3D plinth                                */
#ifndef Xu2DPOL_PLINTH
#define Xu2DPOL_PLINTH 3
#endif
/* type_code: 3D line 1 pixel thickness                                  */
#ifndef Xu3DFRAME
#define Xu3DFRAME 4
#endif
/* type_code: 3D polygon with a 3D plinth                                */
#ifndef Xu3DPOL_PLINTH
#define Xu3DPOL_PLINTH 5
#endif
/* type_code: 2D polygon                                                 */
#ifndef Xu2DPOL
#define Xu2DPOL 6
#endif
/* type_code: 3D polygon                                                 */
#ifndef Xu3DPOL
#define Xu3DPOL 7
#endif
/*                                                                       */
/*                                                                       */
/* XuContourQuickDraw - Draw quick 2D contour map                        */
/*                                                                       */
extern XuType XuCallCnv XuContourQuickDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  void      *v_array , /* ra  in  Data point values                      */
  int       num_y    , /* i   in  Y dimension of v_array                 */
  int       num_x      /* i   in  X dimension of v_array                 */
#endif
);
/*                                                                       */
/* XuContourDraw - Draw 2D shaded contour map                            */
/*                                                                       */
extern XuType XuCallCnv XuContourDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  void      *v_array , /* ra  in  Data point values                      */
  int       num_y    , /* i   in  Y dimension of v_array                 */
  int       num_x      /* i   in  X dimension of v_array                 */
#endif
);
/*                                                                       */
/* XuIsolineDraw - Draw 2D isoline map                                   */
/*                                                                       */
extern XuType XuCallCnv XuIsolineDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  void      *v_array , /* ra  in  Data point values                      */
  int       num_y    , /* i   in  Y dimension of v_array                 */
  int       num_x      /* i   in  X dimension of v_array                 */
#endif
);
/*                                                                       */
/* XuIsoline3DDraw - Draw 3D isoline map                                 */
/*                                                                       */
extern XuType XuCallCnv XuIsoline3DDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  void      *z_array , /* ra  in  Data point values                      */
  int       num_y    , /* i   in  Y dimension of z_array                 */
  int       num_x      /* i   in  X dimension of z_array                 */
#endif
);
/*                                                                       */
/* XuIsoline4DDraw - Draw 4D isoline map                                 */
/*                                                                       */
extern XuType XuCallCnv XuIsoline4DDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  void      *z_array , /* ra  in  Data point height values               */
  void      *v_array , /* ra  in  Data point shading values              */
  int       num_y    , /* i   in  Y dimension of arrays                  */
  int       num_x      /* i   in  X dimension of arrays                  */
#endif
);
/*                                                                       */
/* XuIsolineLabel - Set 2D isoline annotation                            */
/*                                                                       */
extern XuType XuCallCnv XuIsolineLabel (
#if NeedFunctionPrototypes
/*                                                                       */
  double    height        , /* r   in  Annotation height (mm)            */
  int       num_decimal   , /* i   in  Number of decimal places          */
  double    grace         , /* r   in  Gap between annotations (mm)      */
  int       quality_code    /* i   in  Quality display option            */
#endif
);
/*                                                                       */
/* height: Ignore argument                                               */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/* num_decimal: Ignore argument                                          */
#ifndef XuI_IGNORE
#define XuI_IGNORE 9999
#endif
/* grace: Ignore argument                                                */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/* quality_code: No contour annotation                                   */
#ifndef XuOFF
#define XuOFF 0
#endif
/* quality_code: Simple annotation strategy selected                     */
#ifndef XuSIMPLE
#define XuSIMPLE 1
#endif
/* quality_code: Annotations are moved to less curved places             */
#ifndef XuCURVATURE_CHECK
#define XuCURVATURE_CHECK 2
#endif
/* quality_code: Annotations are moved to less curved places,            */
#ifndef XuOVERLAP_CHECK
#define XuOVERLAP_CHECK 3
#endif
/*                                                                       */
/*                                                                       */
/* XuIsolineLabelHeight - Set isoline label height                       */
/*                                                                       */
extern XuType XuCallCnv XuIsolineLabelHeight (
#if NeedFunctionPrototypes
/*                                                                       */
  void      *height_array , /* ra  in  Annotation heights (mm)           */
  int       num_heights     /* i   in  Number of contour levels          */
#endif
);
/*                                                                       */
/* XuIsolineLabelAngleMode - Set isoline label angle mode                */
/*                                                                       */
extern XuType XuCallCnv XuIsolineLabelAngleMode (
#if NeedFunctionPrototypes
/*                                                                       */
  int       angle_mode    /* i   in  mode                                */
#endif
);
/*                                                                       */
/* angle_mode: Label up vector points to high or low side                */
#ifndef XuHIGH_LOW_SIDE
#define XuHIGH_LOW_SIDE 0
#endif
/* angle_mode: Label up vector points to high side                       */
#ifndef XuHIGH_SIDE
#define XuHIGH_SIDE 1
#endif
/* angle_mode: Label up vector points to low side                        */
#ifndef XuLOW_SIDE
#define XuLOW_SIDE 2
#endif
/*                                                                       */
/*                                                                       */
/* XuIsolineLabelAngleRange - Set isoline label angle range              */
/*                                                                       */
extern XuType XuCallCnv XuIsolineLabelAngleRange (
#if NeedFunctionPrototypes
/*                                                                       */
  double    angle_start  , /* r   in  First limiting angle               */
  double    angle_end      /* r   in  Second limiting angle              */
#endif
);
/*                                                                       */
/* XuIsolineLabelBoxAttr - Set isoline label box attributes              */
/*                                                                       */
extern XuType XuCallCnv XuIsolineLabelBoxAttr (
#if NeedFunctionPrototypes
/*                                                                       */
  int       fill_color  , /* i   in  Fill color of annotation box        */
  int       line_color  , /* i   in  Line color of annotation box        */
  int       line_style  , /* i   in  Linestyle of annotation box         */
  double    line_width    /* r   in  Linewidth of annotation box (mm)    */
#endif
);
/*                                                                       */
/* fill_color: Hollow filling                                            */
#ifndef XuHOLLOW
#define XuHOLLOW 9999
#endif
/*                                                                       */
/*                                                                       */
/* XuMesh - Set mesh attributes                                          */
/*                                                                       */
extern XuType XuCallCnv XuMesh (
#if NeedFunctionPrototypes
/*                                                                       */
  int       code         , /* i   in  Type of grid net                   */
  double    minor_width  , /* r   in  Width of minor lines (mm or pixels)    */
  int       minor_color  , /* i   in  Color index for minor lines        */
  double    x_spacing    , /* r   in  Spacing between major lines in     */
  double    y_spacing    , /* r   in  Spacing between major lines in     */
  double    major_width  , /* r   in  Width of major lines (mm)          */
  int       major_color    /* i   in  Color index for major lines        */
#endif
);
/*                                                                       */
/* code: Only horizontal mesh lines                                      */
#ifndef XuHORIZONTAL
#define XuHORIZONTAL 1
#endif
/* code: Only vertical mesh lines                                        */
#ifndef XuVERTICAL
#define XuVERTICAL 2
#endif
/* code: Only major mesh lines                                           */
#ifndef XuMAJOR
#define XuMAJOR 3
#endif
/* code: All mesh lines                                                  */
#ifndef XuALL_MESH
#define XuALL_MESH 4
#endif
/* code: Only horizontal mesh lines of grid cells inside regions         */
#ifndef XuHORIZONTAL_REGION
#define XuHORIZONTAL_REGION 5
#endif
/* code: Only vertical mesh lines of grid cells inside regions           */
#ifndef XuVERTICAL_REGION
#define XuVERTICAL_REGION 6
#endif
/* code: Only major mesh lines of grid cells inside regions              */
#ifndef XuMAJOR_REGION
#define XuMAJOR_REGION 7
#endif
/* code: Only mesh lines of grid cells inside regions                    */
#ifndef XuALL_MESH_REGION
#define XuALL_MESH_REGION 8
#endif
/*                                                                       */
/*                                                                       */
/* XuContour3DDraw - Draw 3D shaded contour map                          */
/*                                                                       */
extern XuType XuCallCnv XuContour3DDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  void      *z_array , /* ra  in  Data point values                      */
  int       num_y    , /* i   in  Y dimension of z_array                 */
  int       num_x      /* i   in  X dimension of z_array                 */
#endif
);
/*                                                                       */
/* XuContour4DDraw - Draw 4D shaded contour map                          */
/*                                                                       */
extern XuType XuCallCnv XuContour4DDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  void      *z_array , /* ra  in  Data point elevation values            */
  void      *v_array , /* ra  in  Data point shading values              */
  int       num_y    , /* i   in  Y dimension of arrays                  */
  int       num_x      /* i   in  X dimension of arrays                  */
#endif
);
/*                                                                       */
/* XuIsolineTickColors - Set isoline tickmark symbol colors              */
/*                                                                       */
extern XuType XuCallCnv XuIsolineTickColors (
#if NeedFunctionPrototypes
/*                                                                       */
  void      *color_array , /* ra  in  Isoline tickmark symbol colors (mm)    */
  int       num_colors     /* i   in  Number of tickmark symbol colors    */
#endif
);
/*                                                                       */
/* XuIsolineTickSymbols - Set isoline tickmark symbols, sizes, gaps and  */
/*                                                                       */
extern XuType XuCallCnv XuIsolineTickSymbols (
#if NeedFunctionPrototypes
/*                                                                       */
  int       *symbol_array        , /* ia  in  Symbols                    */
  void      *size_array          , /* ra  in  Sizes (mm)                 */
  void      *gap_array           , /* ra  in  Gaps (mm) between symbols    */
  int       *justification_array , /* ia  in  Symbol justifications      */
  int       *min_num_symbols     , /* ia  in  Minimum number of symbols per isoline    */
  int       num_levels           , /* i   in  Number of tickmark symbol levels    */
  int       which_isolines         /* i   in  Isoline identification option    */
#endif
);
/*                                                                       */
/* symbol_array: Skip tickmark symbol drawing                            */
#ifndef XuISOLINE_SKIP
#define XuISOLINE_SKIP 0
#endif
/* symbol_array: Line                                                    */
#ifndef XuISOLINE_LINE
#define XuISOLINE_LINE 1
#endif
/* symbol_array: Triangle                                                */
#ifndef XuISOLINE_TRIANGLE
#define XuISOLINE_TRIANGLE 2
#endif
/* symbol_array: Semicircle                                              */
#ifndef XuISOLINE_SEMICIRCLE
#define XuISOLINE_SEMICIRCLE 3
#endif
/* which_isolines: All isolines                                          */
#ifndef XuALL
#define XuALL 0
#endif
/* which_isolines: All innermost closed isolines                         */
#ifndef XuINNERMOST
#define XuINNERMOST 1
#endif
/* which_isolines: All innermost closed isolines {\em without} a label   */
#ifndef XuINNERMOST_NOLABEL
#define XuINNERMOST_NOLABEL 2
#endif
/*                                                                       */
/*                                                                       */
/* XuIsolineTickWidths - Set isoline tickmark symbol widths              */
/*                                                                       */
extern XuType XuCallCnv XuIsolineTickWidths (
#if NeedFunctionPrototypes
/*                                                                       */
  void      *width_array , /* ra  in  Isoline tickmark symbol widths (mm)    */
  int       num_widths     /* i   in  Number of tickmark symbol widths    */
#endif
);
/*                                                                       */
/* width_array: Ignore argument                                          */
#ifndef XuF_IGNORE
#define XuF_IGNORE 999.999
#endif
/*                                                                       */
/*                                                                       */
/* XuMapPolygonDraw - Draw 2D color-shaded polygon map                   */
/*                                                                       */
extern XuType XuCallCnv XuMapPolygonDraw (
#if NeedFunctionPrototypes
/*                                                                       */
  void      *x_array       , /* ra  in  X-coordinate values              */
  void      *y_array       , /* ra  in  Y-coordinate values              */
  int       num_points     , /* i   in  Number of coordinate pairs       */
  double    shading_value    /* r   in  Shading value of the polygon     */
#endif
);
/*                                                                       */
/* num_points: Terminate drawing of polygon map                          */
#ifndef XuTERMINATE
#define XuTERMINATE 9999
#endif
/*                                                                       */
/*                                                                       */
/* XuContourQuickSize - Set grid size for quick contouring               */
/*                                                                       */
extern XuType XuCallCnv XuContourQuickSize (
#if NeedFunctionPrototypes
/*                                                                       */
  int       unit_code  , /* i   in  Grid size option                     */
  double    width      , /* r   in  Grid size in X direction             */
  double    height       /* r   in  Grid size in Y direction             */
#endif
);
/*                                                                       */
/* unit_code: Sizes are given in mm                                      */
#ifndef XuSIZE_MM
#define XuSIZE_MM 0
#endif
/* unit_code: Sizes are given in user units                              */
#ifndef XuSIZE_USER
#define XuSIZE_USER 1
#endif
/*                                                                       */
/*                                                                       */
/* XuPlinthColor - Set 3D plinth face color                              */
/*                                                                       */
extern XuType XuCallCnv XuPlinthColor (
#if NeedFunctionPrototypes
/*                                                                       */
  int       color_index    /* i   in  Color index of the 3D faces        */
#endif
);
/*                                                                       */
/* color_index: Shaded walls                                             */
#ifndef XuSHADED
#define XuSHADED -9999
#endif
/*                                                                       */
/*                                                                       */
/* XuGriddingCriteria - Set gridding ambiguity resolving for interpolati */
/*                                                                       */
extern XuType XuCallCnv XuGriddingCriteria (
#if NeedFunctionPrototypes
/*                                                                       */
  int       gridding_code    /* i   in  Gridding resolving option        */
#endif
);
/*                                                                       */
/* gridding_code: Average value                                          */
#ifndef XuAVERAGE
#define XuAVERAGE 0
#endif
/* gridding_code: Minimum value                                          */
#ifndef XuMIN
#define XuMIN 1
#endif
/* gridding_code: Maximum value                                          */
#ifndef XuMAX
#define XuMAX 2
#endif
/* gridding_code: First value that is not an ``undefined'' value         */
#ifndef XuFIRST_VALUE
#define XuFIRST_VALUE 3
#endif
/* gridding_code: Last value that is not an ``undefined'' value          */
#ifndef XuLAST_VALUE
#define XuLAST_VALUE 4
#endif
/* gridding_code: Sum of values                                          */
#ifndef XuSUM
#define XuSUM 5
#endif
/*                                                                       */

#ifdef __cplusplus
}                                                        /* for C++ V2.0 */
#endif

#endif /* _agxcon_h */
