/*
                        Copyright (c) 1993 by
                        Advanced Visual Systems Inc.
                        All Rights Reserved

        This software comprises unpublished confidential information of
        Advanced Visual Systems Inc. and may not be used, copied or made
        available to anyone, except in accordance with the license
        under which it is furnished.

        This file is under Perforce control
        $Id: //depot/express/fcs70/include/agx/mpickutl.h#1 $
*/

/*
 * mpickutl.h -- Utility functions for mpick set by callback system
 */

#ifndef MPICKUTL_H
#define MPICKUTL_H

#include <avs/port.h>
#ifdef IRIX6_OBSOLETE

#ifndef AGINT
#define AGINT long
#endif

#ifndef AGFLOAT
#define AGFLOAT double
#endif

#else // not IRIX6_OBSOLETE

#ifndef AGINT
#define AGINT int
#endif

#ifndef AGFLOAT
#define AGFLOAT float
#endif

#endif // not IRIX6_OBSOLETE

/* ----------------------------------------------------------------------
 * Do computer dependent fortran function naming convention
 * ----------------------------------------------------------------------
 */
#if defined (VAX) || defined (__hpux) || defined (_AIX)
#define MPGEOM mpgeom
#define MPALLO mpallo
#define MPFREE mpfree
#define MPLINE mpline
#define MPRECT mprect
#define MPPOLY mppoly
#define CALL_TYPE
#else
#if defined (WIN32)
#define CALL_TYPE _stdcall
#define MPGEOM MPGEOM
#define MPALLO MPALLO
#define MPFREE MPFREE
#define MPLINE MPLINE
#define MPRECT MPRECT
#define MPPOLY MPPOLY
#else
#define MPGEOM mpgeom_
#define MPALLO mpallo_
#define MPFREE mpfree_
#define MPLINE mpline_
#define MPRECT mprect_
#define MPPOLY mppoly_
#define CALL_TYPE
#endif
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Needed to separate AGX into a dll
 *	This is a set of callback functions
 */
typedef struct _AgxCallBlock {
    void (*mpgeom)(void*, AGFLOAT *, AGINT *);
    void (*mpallo)(AGINT *, AGINT *, long *, long *);
    void (*mpfree)();
    void (*mppoly)(AGINT *);
    void (*mpline)(AGINT *, AGINT *);
    void (*mprect)(AGINT *, AGINT *);
} AgxCallBlockT, *AgxCallBlockP;

void XuSetCallBlock(AgxCallBlockP);

/* ----------------------------------------------------------------------
 * Get pixel and window size
 * ----------------------------------------------------------------------
 */
void CALL_TYPE MPGEOM(
    void *daptr,
    AGFLOAT pixelSize[],
    AGINT windowSize[]);
/* ---------------------------------------------------------------------- */

/* ----------------------------------------------------------------------
 * Allocate memory and return offset into fortran array
 * ----------------------------------------------------------------------
 */
void CALL_TYPE MPALLO(
    AGINT *num,
    AGINT *xybuf,
    long *ix,
    long *iy);
/* ---------------------------------------------------------------------- */

/* ----------------------------------------------------------------------
 * Free memory used by MPICK
 * ----------------------------------------------------------------------
 */
void CALL_TYPE MPFREE();
/* ---------------------------------------------------------------------- */

/* ----------------------------------------------------------------------
 * Hit for polygon with num coordinates in xyBuffer
 * ----------------------------------------------------------------------
 */
void CALL_TYPE MPPOLY(
    AGINT *num);
/* ---------------------------------------------------------------------- */

/* ----------------------------------------------------------------------
 * Hit for line with num coordinates in xyBuffer
 * ----------------------------------------------------------------------
 */
void CALL_TYPE MPLINE(
    AGINT *lineWidth,
    AGINT *num);
/* ---------------------------------------------------------------------- */

/* ----------------------------------------------------------------------
 * Hit for rectangle
 * ----------------------------------------------------------------------
 */
void CALL_TYPE MPRECT(
    AGINT first[],    /* first and second corner of rectangle */
    AGINT second[]);
/* ---------------------------------------------------------------------- */

#ifdef __cplusplus
}  /* extern "C" */
#endif

#endif /* MPICKUTL_H */
