/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved
	
	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.
	
	This file is under Perforce control
	$Id: //depot/express/fcs70/include/avs/ContainerP.h#1 $
*/

/* ContainerP.h -- Private header file for the Container widget */

/*---------------------------------------------------------------------*/

/* Prevent the contents of this file from being included more than once */

#ifndef _ContainerP_h
#define _ContainerP_h

/* Public header file for this widget class */

#include <avs/Container.h>

/* Public header file for the superclass */

#if (XmVersion > 1001)
#include <Xm/ManagerP.h>
#else
#include <Xm/XmP.h>
#endif

/*--------------------------------------------------------------------*/
/*                     Class record definition                        */
/*--------------------------------------------------------------------*/

/* Class part structure */

typedef struct _ContainerClassPart {

    XtPointer  extension;

} ContainerClassPart;

/* Full class record structure */

typedef struct _ContainerClassRec {

    CoreClassPart        core_class;
    CompositeClassPart   composite_class;
    ConstraintClassPart  constraint_class;
    XmManagerClassPart   manager_class;
    ContainerClassPart   container_class;

} ContainerClassRec;

/* External definition of widget class record */

externalref ContainerClassRec containerClassRec;

/*--------------------------------------------------------------------*/
/*                   Instance structure definition                    */
/*--------------------------------------------------------------------*/

/* Instance part structure */

typedef struct _ContainerPart {

    /* Public resources */

    int  unused;

    /* Private resources */

} ContainerPart;

/* Full instance record structure */

typedef struct _ContainerRec {

    CorePart        core;
    CompositePart   composite;
    ConstraintPart  constraint;
    XmManagerPart   manager;
    ContainerPart   container;

} ContainerRec;

/*--------------------------------------------------------------------*/

#endif /* _ContainerP_h */
