/*
			Copyright (c) 1996 by
			Advanced Visual Systems Inc.
			All Rights Reserved
	
	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.
	
	This file is under Perforce control
	$Id: //depot/express/fcs70/include/avs/RenderVP.h#1 $
*/

/* RenderVP.h -- Private header file for the RenderView widget */

/*---------------------------------------------------------------------*/

/* Prevent the contents of this file from being included more than once */

#ifndef _RenderVP_h
#define _RenderVP_h

/* Public header file for this widget class */

#include <avs/RenderV.h>

/* Public header file for the superclass */

#if (XmVersion > 1001)
#include <Xm/ManagerP.h>
#else
#include <Xm/XmP.h>
#endif

/*--------------------------------------------------------------------*/
/*             Macros for accessing widget instance fields            */
/*--------------------------------------------------------------------*/

/* Public instance resource macros */

#define RV_visual(w) \
  (((RenderViewWidget) (w))->render_view.visual)

/*--------------------------------------------------------------------*/
/*                     Class record definition                        */
/*--------------------------------------------------------------------*/

/* Class part structure */

typedef struct _RenderViewClassPart {

    XtPointer  extension;

} RenderViewClassPart;

/* Full class record structure */

typedef struct _RenderViewClassRec {

    CoreClassPart        core_class;
    CompositeClassPart   composite_class;
    ConstraintClassPart  constraint_class;
    XmManagerClassPart   manager_class;
    RenderViewClassPart  render_view_class;

} RenderViewClassRec;

/* External definition of widget class record */

externalref RenderViewClassRec renderViewClassRec;

/*--------------------------------------------------------------------*/
/*                   Instance structure definition                    */
/*--------------------------------------------------------------------*/

/* Instance part structure */

typedef struct _RenderViewPart {

    /* Public resources */

    Visual  *visual;

    /* Private resources */

} RenderViewPart;

/* Full instance record structure */

typedef struct _RenderViewRec {

    CorePart        core;
    CompositePart   composite;
    ConstraintPart  constraint;
    XmManagerPart   manager;
    RenderViewPart  render_view;

} RenderViewRec;

/*--------------------------------------------------------------------*/

#endif /* _RenderVP_h */
