/*
                        Copyright (c) 1994 by
                        Advanced Visual Systems Inc.
                        All Rights Reserved

        This software comprises unpublished confidential information of
        Advanced Visual Systems Inc. and may not be used, copied or made
        available to anyone, except in accordance with the license
        under which it is furnished.

        This file is under Perforce control
        $Id: //depot/express/fcs70/include/avs/Tree.h#1 $
*/

/* NAME Tree   */
/* PACK h      */
/* COMP NONE   */
/* VERS 940719 */
/* HIST 1V0    */
/*---------------------------------------------------------------------*/
/*                                                                     */
/*                A V S /  U N I R A S   S O F T W A R E               */
/*                                                                     */
/*     The   contents   of   this   document  are  proprietary  to     */
/*                                                                     */
/*                     A V S / U N I R A S  A/S                        */
/*                                                                     */
/*     and  are  not  to  be  disclosed  to  others  or  used  for     */
/*     purposes  other  than  described  in  agreement  or written     */
/*     approval  of  the  owners.                                      */
/*                                                                     */
/*---------------------------------------------------------------------*/
/* @(#) Tree.h 1.2 07/27/94 AVS/UNIRAS */
 
#ifndef _Tree_h
#define _Tree_h
 
#include <assert.h>

/*****************************************************************************
                                  Any Defines
 ****************************************************************************/

#define XmNhorizontalSpace "horizontalSpace"
#define XmNverticalSpace "verticalSpace"
#define XmCPad "Pad"
#define XmNsuperNode "superNode"
#define XmCSuperNode "SuperNode"

#define XmNbranchStyle "branchStyle"
#define XmCBranchStyle "branchStyle"

#define	XmBranchFromMiddle	0
#define	XmBranchFromTop		1
#define	XmBranchFromBottom	2

/*****************************************************************************
                                  New Types
 ****************************************************************************/

/*
** Declare the class constant
*/
extern WidgetClass xmTreeWidgetClass;

/*
** Declare specific Page class and instance datatypes
*/
typedef struct _XmTreeClassRec *XmTreeWidgetClass;
typedef struct _XmTreeRec      *XmTreeWidget;

/*****************************************************************************
                       Convenience Function Declarations
 ****************************************************************************/
 
#ifdef __cplusplus  /* Do not leave open across includes */
extern "C" {        /* For C++ V2.0 */
#endif
 
extern Widget XmCreateTree (
#if NeedFunctionPrototypes
   Widget   parent,
   char    *name,
   ArgList  arglist,
   Cardinal argcount
#endif
);

extern Widget XmCreateScrolledTree (
#if NeedFunctionPrototypes
   Widget   parent,
   char    *name,
   ArgList  arglist,
   Cardinal argcount
#endif
);

extern void XmSetBranchStyle (
#if NeedFunctionPrototypes
   Widget	root,
   int		spreadStyle
#endif
);

#ifdef __cplusplus
}  /* For C++ V2.0 */
#endif
 
#endif /* _Tree_h */
/* DON'T ADD ANYTHING AFTER THIS #endif */
