//			Copyright (c) 1993 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/include/avs/ag/attrname.hxx#1 $
//

// attrname.hxx - Declare all the attribute name strings and enum types

//----------------------------------------------------------------------
#ifndef AG_ATTRNAME_HXX
#define AG_ATTRNAME_HXX

#ifndef CXXUTIL_ENUM_HXX
#include <avs/cxxutl/enum.hxx>
#endif

//----------------------------------------------------------------------
// Enum attributes
//----------------------------------------------------------------------
extern "C" UtEnumObj contourTypeValues;
typedef  UtEnum<&contourTypeValues> ContourTypeEnum;
extern "C" UtEnumObj graphTypeValues;
typedef  UtEnum<&graphTypeValues> GraphTypeEnum;
extern "C" UtEnumObj scaleTypeValues;
typedef  UtEnum<&scaleTypeValues> ScaleTypeEnum;
extern "C" UtEnumObj labelModeValues;
typedef  UtEnum<&labelModeValues> LabelModeEnum;
extern "C" UtEnumObj labelPositionValues;
typedef  UtEnum<&labelPositionValues> LabelPositionEnum;
extern "C" UtEnumObj multiLineJustifications;
typedef  UtEnum<&multiLineJustifications> MultiLineJustificationEnum;
extern "C" UtEnumObj horizontalJustifications;
typedef  UtEnum<&horizontalJustifications> HorizontalJustificationEnum;
extern "C" UtEnumObj verticalJustifications;
typedef  UtEnum<&verticalJustifications> VerticalJustificationEnum;
extern "C" UtEnumObj arcTypes;
typedef  UtEnum<&arcTypes> ArcTypeEnum;
extern "C" UtEnumObj pieLabelPositions;
typedef  UtEnum<&pieLabelPositions> PieLabelPositionEnum;
extern "C" UtEnumObj pieLabelContents;
typedef  UtEnum<&pieLabelContents> PieLabelContentEnum;

//----------------------------------------------------------------------
// AgAttribute names
//----------------------------------------------------------------------
extern const char *AgNangle;
extern const char *AgNangleInterval;
extern const char *AgNarcType;
extern const char *AgNarrowColor;
extern const char *AgNaxleColor;
extern const char *AgNaxleWidth;
extern const char *AgNbarFrameWidth;
extern const char *AgNbarOffset;
extern const char *AgNbarOffsets;
extern const char *AgNbarWidth;
extern const char *AgNbaseValuesY;
extern const char *AgNbaseVector;
extern const char *AgNclassValues;
extern const char *AgNclip;
extern const char *AgNcolor;
extern const char *AgNcolors;
extern const char *AgNcontourType;
extern const char *AgNdataMapper;
extern const char *AgNdiameter;
extern const char *AgNexplodeOffset;
extern const char *AgNfield;
extern const char *AgNfillColor;
extern const char *AgNfont;
extern const char *AgNframeColor;
extern const char *AgNframeWidth;
extern const char *AgNgeometry;
extern const char *AgNgraphColors;
extern const char *AgNgraphType;
extern const char *AgNheight;
extern const char *AgNhorizontalJustification;
extern const char *AgNisoLineFeatheringMinDistance;
extern const char *AgNisoLineFeatheringMinLength;
extern const char *AgNisoLineLabelAngleInterval;
extern const char *AgNisoLineLabelColor;
extern const char *AgNisoLineLabelDecimals;
extern const char *AgNisoLineLabelDistance;
extern const char *AgNisoLineLabelFont;
extern const char *AgNisoLineLabelFrequency;
extern const char *AgNisoLineLabelHeight;
extern const char *AgNlabelBoxFillColor;
extern const char *AgNlabelBoxFrameColor;
extern const char *AgNlabelBoxFrameWidth;
extern const char *AgNlabelColor;
extern const char *AgNlabelContent;
extern const char *AgNlabelDecimals;
extern const char *AgNlabelFont;
extern const char *AgNlabelHeight;
extern const char *AgNlabelJustification;
extern const char *AgNlabelMode;
extern const char *AgNlabelPosition;
extern const char *AgNlabelPowerFactor;
extern const char *AgNlabelPrefix;
extern const char *AgNlabelStrings;
extern const char *AgNlabelSuffix;
extern const char *AgNlegendText;
extern const char *AgNlimitsMarginX;
extern const char *AgNlimitsMarginY;
extern const char *AgNlimitsR;
extern const char *AgNlimitsT;
extern const char *AgNlimitsX;
extern const char *AgNlimitsY;
extern const char *AgNlineStyle;
extern const char *AgNlineWidth;
extern const char *AgNmajorIsoLineColor;
extern const char *AgNmajorIsoLineFrequency;
extern const char *AgNmajorIsoLineReference;
extern const char *AgNmajorIsoLineStyle;
extern const char *AgNmajorIsoLineWidth;
extern const char *AgNmajorReferenceR;
extern const char *AgNmajorReferenceT;
extern const char *AgNmajorReferenceX;
extern const char *AgNmajorReferenceY;
extern const char *AgNmajorStepR;
extern const char *AgNmajorStepT;
extern const char *AgNmajorStepX;
extern const char *AgNmajorStepY;
extern const char *AgNmajorTickColor;
extern const char *AgNmajorTickLineStyle;
extern const char *AgNmajorTickOn;
extern const char *AgNmajorTickWidth;
extern const char *AgNmaxClass;
extern const char *AgNminClass;
extern const char *AgNminorIsoLineColor;
extern const char *AgNminorIsoLineStyle;
extern const char *AgNminorIsoLineWidth;
extern const char *AgNminorTickColor;
extern const char *AgNminorTickCount;
extern const char *AgNminorTickLineStyle;
extern const char *AgNminorTickWidth;
extern const char *AgNmultiLineJustification;
extern const char *AgNmultiLineSpacingFactor;
extern const char *AgNnegativeColor;
extern const char *AgNniceLimits;
extern const char *AgNnumClasses;
extern const char *AgNnumColumns;
extern const char *AgNoriginR;
extern const char *AgNpositionR;
extern const char *AgNpositionT;
extern const char *AgNpositionX;
extern const char *AgNpositionY;
extern const char *AgNpowerExponent;
extern const char *AgNpriority;
extern const char *AgNreferenceValue;
extern const char *AgNscaleTypeX;
extern const char *AgNscaleTypeY;
extern const char *AgNscatterSymbol;
extern const char *AgNscatterSymbols;
extern const char *AgNshiftPosition;
extern const char *AgNsymbolFont;
extern const char *AgNsymbolHeight;
extern const char *AgNtext;
extern const char *AgNtextColor;
extern const char *AgNtextFont;
extern const char *AgNtextHeight;
extern const char *AgNtexts;
extern const char *AgNtitle;
extern const char *AgNtitleColor;
extern const char *AgNtitleFont;
extern const char *AgNtitleHeight;
extern const char *AgNtransform;
extern const char *AgNuniformScaling;
extern const char *AgNupVector;
extern const char *AgNusedLimitsR;
extern const char *AgNusedLimitsT;
extern const char *AgNusedLimitsX;
extern const char *AgNusedLimitsY;
extern const char *AgNvalues;
extern const char *AgNvaluesR;
extern const char *AgNvaluesT;
extern const char *AgNvaluesX;
extern const char *AgNvaluesY;
extern const char *AgNverticalJustification;
extern const char *AgNvisibility;
extern const char *AgNwidth;
//----------------------------------------------------------------------
// Alias names
//----------------------------------------------------------------------
extern const char *AgNposition;
extern const char *AgNmajorReference;
extern const char *AgNmajorStep;
extern const char *AgNarcAngleInterval;
//----------------------------------------------------------------------
// Private names (for internal use only)
//----------------------------------------------------------------------
extern const char *AgN_graphNum;
extern const char *AgN_barGraphNum;
extern const char *AgN_scatterGraphNum;
extern const char *AgN_limits;
extern const char *AgN_scaleTypeX;
extern const char *AgN_scaleTypeY;
// Private alias
extern const char *AgN_scaleType;
extern const char *AgN_scaleTypeOther;
extern const char *AgN_limits;

#endif
