//			Copyright (c) 1993 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/include/avs/ag/axis.hxx#1 $
//

// axis.hxx -- Header file for Axis, AgXAxis and AgYAxis classes

//----------------------------------------------------------------------
#ifndef AG_AXIS_HXX
#define AG_AXIS_HXX

#ifndef AG_PRIM_HXX
#include "prim.hxx"
#endif

#ifndef AG_WORLD_HXX
#include "world.hxx"
#endif

//----------------------------------------------------------------------
// Protected base class for AgXAxis and AgYAxis
//----------------------------------------------------------------------
class AgAxis : public AgPrimitive 
//----------------------------------------------------------------------
{
  public:

    virtual AgPrimitiveType primitiveType();

  protected:
    AgAxis();
    virtual void _drawThis();
    virtual int _hitThis();

    float _position;
};

//----------------------------------------------------------------------
class AgXAxis : public AgAxis 
//----------------------------------------------------------------------
{

  public:
    AgXAxis();
    virtual void print() {printf("AgXAxis ");};

  protected:
    virtual void _drawThis();
    virtual void _updateThis(int first);
};

//----------------------------------------------------------------------
class AgYAxis : public AgAxis 
//----------------------------------------------------------------------
{

  public:
    AgYAxis();
    virtual void print() {printf("AgYAxis ");};

  protected:
    virtual void _drawThis();
    virtual void _updateThis(int first);
};

#endif
