//			Copyright (c) 1993 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/include/avs/ag/contour.hxx#1 $
//

// contour.hxx - Header file for AgContour class

//----------------------------------------------------------------------

#ifndef AG_CONTOUR_HXX
#define AG_CONTOUR_HXX

#ifndef AG_PRIM_HXX
#include "prim.hxx"
#endif

#ifndef AG_CONTWRLD_HXX
#include "contwrld.hxx"
#endif

#ifndef AG_LSTYLE_HXX
#include "lstyle.hxx"
#endif

#ifndef AG_ENUMDEFS_HXX
#include "enumdefs.hxx"
#endif

#ifndef AG_FIELD_HXX
#include "field.hxx"
#endif

#ifndef AG_DATAMAP_HXX
#include "datamap.hxx"
#endif

class AgContour;

#ifndef AG_CONTLEG_HXX
#include "contleg.hxx"
#endif

#ifndef CXXUTIL_ARRAY_HXX
#include <avs/cxxutl/array.hxx>
#endif

//----------------------------------------------------------------------
class AgContour : public AgPrimitive 
//----------------------------------------------------------------------
{
    friend class AgContourLegend;

  public:
    AgContour();
    virtual ~AgContour();

    virtual AgPrimitiveType primitiveType() {return AgCONTOUR;}

    virtual void print() {printf("AgContour ");}

    // Define access functions for UtPtrAttr<AgField> attributes
    AgPrimitive &setFieldAttr(const char *name, 
        const AgField &value,
        UtAttrSearchType search=UtDO_CHANGE) {
            ((UtPtrAttr<AgField>*)findAttr(name, search))->set(value);
            return *this;
    }
    AgField &getFieldAttr (const char *name, 
        UtAttrSearchType search=UtIS_SET) {
            return ((UtPtrAttr<AgField>*)findAttr(name, search))->get();
    }

    // Define access functions for UtPtrAttr<AgDataMapper> attributes
    AgPrimitive &setDataMapperAttr(const char *name, 
        const AgDataMapper &value,
        UtAttrSearchType search=UtDO_CHANGE) {
            ((UtPtrAttr<AgDataMapper>*)findAttr(name, search))->set(value);
            return *this;
    }
    AgDataMapper &getDataMapperAttr (const char *name, 
        UtAttrSearchType search=UtIS_SET) {
            return ((UtPtrAttr<AgDataMapper>*)findAttr(name, search))->get();
    }

//  virtual int _hitThis();
//  virtual void _getHitData(int hit, float &hitDataX, float &hitDataY);

    // function to return limits for this object
    virtual int getLimits(float *xmin, float *xmax, 
                          float *ymin, float *ymax);


    // Check if this object is valid and if not then dont draw it or
    // or any children
    virtual int isValid();

  protected:

  private:

    AgContourLegend *_legend;

    UtArray<AGFLOAT> _classValues;
    UtArray<AGINT>   _classColors;
    UtArray<AGINT>   _lineStyles;
    UtArray<AGFLOAT> _lineWidths;

    int _numDecimals;

    virtual void _drawThis();
};

#endif
