//			Copyright (c) 1993 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/include/avs/ag/datamap.hxx#1 $
//

// datamap.hxx - Header file for AgDatamap class

//----------------------------------------------------------------------
#ifndef AG_DATAMAP_HXX
#define AG_DATAMAP_HXX

#ifndef CXXUTIL_ARRAY_HXX
#include <avs/cxxutl/array.hxx>
#endif

#ifndef AG_COLOR_HXX
#include "color.hxx"
#endif

#include <avs/port.h>

#ifdef IRIX6_OBSOLETE
#define AGFLOAT double
#else
#define AGFLOAT float
#endif

//----------------------------------------------------------------------
// Typedef for user supplied function to map data value to color
//----------------------------------------------------------------------
typedef void AgDataMapperFunc(AGFLOAT *dataValues, xp_long numDataValues,
    AgColor *colors);

//----------------------------------------------------------------------
// Class to represent a Toolmaster++ Datamap
// This is a facility to map data values into colors
//----------------------------------------------------------------------
class AgDataMapper
//----------------------------------------------------------------------
{
  public:
    AgDataMapper() : _mapperFunction(0) {}
    AgDataMapper(AgDataMapperFunc *mapperFunction)
        : _mapperFunction(mapperFunction) {}

    void setMapperFunction(AgDataMapperFunc *mapperFunction) {
        _mapperFunction = mapperFunction;
    }
    void getColors(AGFLOAT *dataValues,
        xp_long numDataValues, AgColor *colors) {
            (*_mapperFunction)(dataValues, numDataValues, colors);
    }

  private:
    AgDataMapperFunc *_mapperFunction;

};
#endif
