//			Copyright (c) 1993 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/include/avs/ag/drawarea.hxx#1 $
//

// drawarea.hxx - Header file for AgDrawingArea class

//----------------------------------------------------------------------

#ifndef AG_DRAWAREA_HXX
#define AG_DRAWAREA_HXX

#include <stdio.h>
#include <agx/agx.h>

#ifdef WIN32
#undef min
#undef max
#else
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#endif

#ifndef AG_COLOR_HXX
#include "color.hxx"
#endif

#ifndef AG_PRIM_HXX
#include "prim.hxx"
#endif

//----------------------------------------------------------------------
// Define the AgDrawingArea object
// A drawing area is an object to which drawing can be performed
// This can be realized as a window or a piece of paper
//----------------------------------------------------------------------
class AgDrawingArea : public AgPrimitive 
//----------------------------------------------------------------------
{
    friend class AgViewport;

  public:
    static const int &pickPixelX() {return _pickPixelX;}
    static const int &pickPixelY() {return _pickPixelY;}
    static const int &trapRadius() {return _trapRadius;}
    static const int &treatLineAsPolygon() {return _treatLineAsPolygon;}
    static void treatLineAsPolygon(int flag) {_treatLineAsPolygon=flag;}
    static void setHit(int hit) {if (!_isHit) _isHit=hit;}
    static const int &isHit() {return _isHit;}
    static const int &pickMode() {return _pickMode;}
    static const int &agxInitialized() {return _agxInitialized;}
    static const int &agxError() {return _agxError;}
    static void usePickDevice();
    static void useWindowDevice();

    // Is this a RGB device
    static int isRGBDevice() {
        return ((AgDrawingArea*)_drawDownStack[0])->_isRGBDevice;
    }

    // function to convert a mm value into pixel value
    static float mmToPixel(float mm) {
        return mm/_pixelSizeAvg;
    }
    // function to convert a pixel value into mm value
    static float pixelToMM(float pixel) {
        return pixel*_pixelSizeAvg;
    }
    AgDrawingArea(const char *deviceString = 0);
    virtual ~AgDrawingArea();
    virtual AgPrimitiveType primitiveType() {return AgDRAWINGAREA;}

#ifdef WIN32
    AgDrawingArea &setupWindows(HDC hDC, HWND hWnd, int isRGBDevice=1);
#else
    AgDrawingArea &setupX11(Display* display, Window window);
#endif

#ifndef WIN32
    AgDrawingArea &standardColormap(XStandardColormap *stdcmap);
#endif

#ifndef WIN32
    AgDrawingArea &drawable(Drawable drawable) {
        _drawable = drawable; 
        return *this;
    }
#endif

    void getPixelSize(float *pixelSizeX, float *pixelSizeY);

    void getSize(int *pixelsWidth, int *pixelsHeight);

    void getSize(float *width, float *height);

    // Change size of non window device
    AgDrawingArea &size(float mmWidth, float mmHeight);

    // Is AgDrawingArea valid for drawing into
    // When invalid nothing is drawn for this AgDrawingArea
    virtual int isValid();

    virtual AgPrimitive &clear();
    virtual void print() {printf("AgDrawingArea ");}
    void doHighlight(int flag) {_doHighlight = flag;}
    void highlightColor (AgColor highlightColor) {
        _highlightColor = highlightColor;
    }

    // pick function if returned pointer is 0 then nothing was picked
    AgPrimitive *pick (int pixelX, int pixelY, int _trapRadius=1);

    // misc functions to return pick information
    int hitIndex() const {return _hitIndex;}
    float hitPointX() const {return _hitPointX;}
    float hitPointY() const {return _hitPointY;}
    float hitDataX() const {return _hitDataX;}
    float hitDataY() const {return _hitDataY;}

  protected:
    virtual void _updateThis(int first);
    virtual void _drawThis();

  private:

    // Resize device
    void _resize();

    // Flag to tell if we need to init device at next draw
    int _needInit;
    // Private init function
    void _init();

    // Toolmaster device context
    AGINT _deviceContext;

    // Device context for special pick driver
    static AGINT _pickDeviceContext;

    // Device context for X11 driver
    static AGINT _windowDeviceContext;

    // Empty device context which is selected when no other device is
    static AGINT _emptyDeviceContext;

    // Device string
    UtString _deviceString;

    // Is device open
    int _isDeviceOpen;
    
    // X11/Windows device specific stuff
    int _isWindowDevice;
#ifdef WIN32
    HWND _hWnd;
    HDC  _hDC;
    HPALETTE _hPalette;
#else
    Display *_display;
    Window _window;
    Drawable _drawable;
    XStandardColormap *_stdcmap;
    Colormap _colormap;
    Visual *_visual;
    int _depth;
#endif

    // size information
    float _mmWidth, _mmHeight;
  public: // Dirty use by mpickcb functions
    int _pixelsWidth, _pixelsHeight;
  private:

    // For non window device we also need to keep physical size
    int _realPixelsWidth, _realPixelsHeight;

    // Is device RGB (additive) or CMY (subtractive) base
    int _isRGBDevice;
    
    // Highlight stuff for picking
    AgColor _highlightColor;
    int _doHighlight;

    // picked object for AgDrawingArea pick function
    AgPrimitive *_pickedObject;

    // index of last picked data point 
    int _hitIndex;

    // world coordinate of last pick point
    AGFLOAT _hitPointX;
    AGFLOAT _hitPointY;

    // data value for hit point
    float _hitDataX;
    float _hitDataY;

    // Flag telling if agx is initialized or not
    // this flag is set by AgDrawingArea instance function
    static int _agxInitialized;

    // Flag telling if an error occured in agx
    static int _agxError;

    // Function which is called by agx then an error occur
    static void _agxErrorCheck(
        char *message,
        AGINT  *action,
        void *dummy);

    // The pixel size in mm for the draw being done right now
    // These values are set by the Drawingarea in current draw path
  public: // Dirty use by mpickcb functions
    static float _pixelSizeX, _pixelSizeY;
  private:
    static float _pixelSizeAvg;

    // Special stuff for pick device
    static int _pickMode;   // Are we in pick mode(1) or highlight mode(2) ?
    static int _pickPixelX;
    static int _pickPixelY;
    static int _trapRadius;
    static int _isHit;
    static int _treatLineAsPolygon;
};

#endif
