//			Copyright (c) 1993 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/include/avs/ag/font.hxx#1 $
//

// font.hxx - Header file for AgFont class

//----------------------------------------------------------------------
#ifndef AG_FONT_HXX
#define AG_FONT_HXX

#ifndef CXXUTIL_STRING_HXX
#include <avs/cxxutl/string.hxx>
#endif

//----------------------------------------------------------------------
// Class to represent a Toolmaster++ font
//----------------------------------------------------------------------
class AgFont 
//----------------------------------------------------------------------
{
  public:
    AgFont(const char* name = "helvetica") {
        set(name);
    }

    // since there is both an operator=(char*) and an operator char*() 
    // wee need a default assignment constructor to avoid the above being used
    AgFont(const AgFont &from) {
        _copy(from);
    }

    // string name
    void set(const char *name);

    // string name by operator=
    AgFont &operator=(const char *name) {
        set(name);
        return *this;
    }

    int mode() const { return _fontMode; };

    // return char* for call directly to agX routines
    const char *agx_name() const;
    operator char*() const { return (char *)agx_name(); } ;
    operator const char*() const { return agx_name(); } ;

    // return int for call directly to agX routines as font mode
    operator int() const {return _fontMode;}

    // since there is both an operator=(char*) and an operator char*() 
    // wee need a default assignment constructor to avoid the above being used
    AgFont &operator=(const AgFont &from) {
        _copy(from);
        return *this;
    }

  private:

    // Used by copy contructor and assignment operator
    void _copy(const AgFont &from) {
        _font = from._font;
        _fontMode = from._fontMode;
    }

    UtString _font;
    int _fontMode;
    static const char *_fontTable[42];
};
#endif
