//			Copyright (c) 1993 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/include/avs/ag/geomprim.hxx#1 $
//

// geomprim.hxx - Header file for AgGeometryPrimitive class

//----------------------------------------------------------------------
#ifndef AG_GEOMPRIM_HXX
#define AG_GEOMPRIM_HXX

#ifndef AG_PRIM_HXX
#include "prim.hxx"
#endif

//----------------------------------------------------------------------
// Protected base class AgPrimitive with geometry
//----------------------------------------------------------------------
class AgGeometryPrimitive : public AgPrimitive
//----------------------------------------------------------------------
{
  public:

    // function to return limits for this object
    virtual int getLimits(float *xmin, float *xmax, 
                          float *ymin, float *ymax);

  protected:
    AgGeometryPrimitive();
    virtual void _userUpdateAttr();
    virtual void _getHitData(int hit, float &hitDataX, float &hitDataY);
    int _polygonHit();
    int _lineHit(int lineWidth);
    int _pointsHit();

    // transform data
    AGFLOAT *_getTransformedX();
    AGFLOAT *_getTransformedY();
    // WARNING: this funtion is ONLY to be called by
    // _getTransformedX and _getTransformedY
    void _updateTransformedData();
    void _scaleAndRotateGeometry(AgGeometry &geometry);   
    virtual int isValid();
    // Pointer to the geometry attribute for speed reason
    AgGeometry *_geometry;

  private:
    UtArray<AGFLOAT> _transformedX, _transformedY;
    int _validTransformedXY;
};
#endif
