//			Copyright (c) 1993 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/include/avs/ag/graphleg.hxx#1 $
//

// graphleg.hxx - Header file for AgGraphLegend class

//----------------------------------------------------------------------
#ifndef AG_GRAPHLEG_HXX
#define AG_GRAPHLEG_HXX

#ifndef CXXUTIL_ATTR_HXX
#include <avs/cxxutl/attr.hxx>
#endif

#ifndef CXXUTIL_PTRLIST_HXX
#include <avs/cxxutl/ptrlist.hxx>
#endif

class AgGraphLegend;

#ifndef AG_GRAPH_HXX
#include "graph.hxx"
#endif

#ifndef AG_GRAPHVP_HXX
#include "graphvp.hxx"
#endif

//----------------------------------------------------------------------
class AgGraphLegend : public AgGeometryPrimitive 
//----------------------------------------------------------------------
{
    friend class AgGraphViewport;
    friend class AgGraph;
    friend class AgPolarGraph;
  public:
    AgGraphLegend ();
    ~AgGraphLegend() {
        if (debug()) printf("DELETING AgGraphLegend\n");

        // before we die be sure all references from graphs are gone
        (void) removeAllGraphs();
    }
    
    virtual AgPrimitiveType primitiveType() {return AgGRAPHLEGEND;}

    // remove all children from this and their parents
    AgGraphLegend &removeAllGraphs();

    virtual void print() {printf("AgGraphLegend ");}

    virtual int isValid();

  protected:

    virtual int _hitThis();
    virtual void _updateThis(int first);
    virtual void _drawThis();

  private:
    UtPtrSortedList<AgGraph> _graphs;
    int _noRows, _numColumns;
    float _columnWidth, _rowHeight, _symbolWidth;
    float _upperRightPoint[2];
};

#endif
