//			Copyright (c) 1993 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/include/avs/ag/text.hxx#1 $
//

// text.hxx - Header file for AgText* primitive class

//----------------------------------------------------------------------
#ifndef AG_TEXT_HXX
#define AG_TEXT_HXX

#ifndef AG_PRIM_HXX
#include "prim.hxx"
#endif

#ifndef AG_WORLD_HXX
#include "world.hxx"
#endif

#ifndef AG_FONT_HXX
#include "font.hxx"
#endif

#ifndef AG_GRAPHICS_HXX
#include "graphics.hxx"
#endif

//----------------------------------------------------------------------
// Base class for the Text primitives
//----------------------------------------------------------------------
class AgBaseText : public AgGraphics 
//----------------------------------------------------------------------
{
    
  public:

  protected:
    AgBaseText();

    virtual void _updateThis(int first);
    virtual int _hitThis();
    virtual void _drawThis();

    virtual int _drawHit(int hit);

  private:
};

//----------------------------------------------------------------------
class AgText : public AgBaseText
//----------------------------------------------------------------------
{
    
  public:
    AgText();

    virtual void print() {printf("AgText ");}
    
    // Check if height is ok
    virtual int isValid();

  protected:
    virtual void _updateThis(int first);

  private:

    int _isValid;
};

//----------------------------------------------------------------------
class AgTransformableText : public AgBaseText
//----------------------------------------------------------------------
{
    
  public:
    AgTransformableText();

    virtual void print() {printf("AgTransformableText %s ",
                 getStringAttr(AgNtext).c_str());}
    
  protected:
    virtual void _updateThis(int first);

  private:
};

//----------------------------------------------------------------------
class AgRestrictedText : public AgBaseText
//----------------------------------------------------------------------
{
    
  public:
    AgRestrictedText();

    virtual void print() {printf("AgRestrictedText %s ",
                 getStringAttr(AgNtext).c_str());}
    
  protected:

  private:
    virtual int _drawHit(int hit);
};

#endif
