//			Copyright (c) 1993 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/include/avs/ag/viewport.hxx#1 $
//

// viewport.hxx - Header file for AgViewport class

//----------------------------------------------------------------------
#ifndef AG_VIEWPORT_HXX
#define AG_VIEWPORT_HXX

//----------------------------------------------------------------------
#ifdef WIN32
#undef min
#undef max
#endif

#include <stdio.h>

#ifndef AG_GEOMPRIM_HXX
#include "geomprim.hxx"
#endif

#ifndef AG_DRAWAREA_HXX
#include "drawarea.hxx"
#endif

//----------------------------------------------------------------------
class AgViewport : public AgGeometryPrimitive 
//----------------------------------------------------------------------
{
    friend class AgWorld;

  public:
    // Constructor takes viewport placement coordinates
    AgViewport();
    virtual AgPrimitiveType primitiveType() {return AgVIEWPORT;}
    virtual void print() {printf("AgViewport ");}
    virtual int isValid() {return _isValid;}

  protected:
    virtual void _drawThis();
    virtual void _updateThis(int first);
    virtual int _hitThis();

  private:
    float _mmOrigX, _mmOrigY, _mmWidth, _mmHeight;
    int _isValid;
};

#endif
