/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/include/avs/animator/GDViewTraverser.hxx#1 $
*/
#ifndef _GDVIEWTRAVERSER_H_
#define _GDVIEWTRAVERSER_H_

#include <avs/gd.h>

//
// abstract GD View Traverser
//
class GDViewTraverser {
 public:
  // typedefs
  typedef int (*GSvirt_func)(...);
  // If the function returns a pointer, declaring it to return a int
  // can be trouble on a 64-bit machine.
  typedef void * (*GSvirt_func_ptr)(...);

  enum TraversalMode { AllFrames, CurrentFrameOnly, ExcludeCurrentFrame, 
                       ActiveHierarchyOnly, PreviousCurrentFrameOnly,
                       ExcludePreviousCurrentFrameOnly 
  };

 public:
  GDViewTraverser(OMobj_id id);
  GDViewTraverser();
  virtual ~GDViewTraverser() {}

  void    setView(GDview *view) { _view = view; };
  GDview *getView() {return _view;};

  void traverseView();
  void traverseCamera(GDcamera *);
  void traverseFrame (GDframe *);
  void traverseObject(GDobject *);

  void setTraversalMode(TraversalMode fTraversalMode) { _fTraversalMode = fTraversalMode;};
  TraversalMode getTraversalMode() { return _fTraversalMode;};
  void stopTraversal() { _stopTraversalFlag = 1;};

 protected:

  OMpfi  OM_get_virt_func(const char *func_name);

  virtual void inView();
  virtual void inCamera(GDcamera *);
  virtual void inFrame(GDframe *);
  virtual void inObject(GDobject *);
  virtual void outObject(GDobject *);

  inline void resetStopFlag() { _stopTraversalFlag = 0;};
  inline int  checkStopFlag() { return _stopTraversalFlag;};

  //
  // state from express
  //
  OMobj_id  _obj_id;
  GDview *  _view;

  // frame traversal mode
  TraversalMode _fTraversalMode;

  // stop traversal flag
  int _stopTraversalFlag;
};
#endif

