/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved
	
	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.
	
	This file is under Perforce control
	$Id: //depot/express/fcs70/include/avs/animator/GS_ListNode.hxx#1 $
*/
#ifndef _GS_LISTNODE_HXX
#define _GS_LISTNODE_HXX

#include <stdio.h> /* for NULL */

// templates
template <class ListItem>
class GS_ListHeader ;

template <class ListItem>
class  GS_ListNode {
  friend class  GS_ListHeader<ListItem>;
    
 public:
  GS_ListNode(int id, ListItem *item = NULL, int refCnt = 1);
  ~GS_ListNode();

  GS_ListNode<ListItem> * AddNode(GS_ListNode<ListItem> *node = NULL);
  GS_ListNode<ListItem> * searchList(ListItem *item);
  GS_ListNode<ListItem> * searchList(int id);

  // set utilities
  void SetItem(ListItem *item);
  inline void SetId(int id) { m_id = id;};

  // get utilities
  inline ListItem *GetItem() { return this ? m_item : NULL;};
  inline int GetId() { return this ? m_id : -1;};

 private:
  int  m_id;
  int  m_refCnt;
  GS_ListNode<ListItem> *m_next;
  ListItem              *m_item;
};


template <class ListItem>
class GS_DiscNode : public GS_ListNode<ListItem> {
public:
  // disable reference counting 
  GS_DiscNode(int id, ListItem *item) :  GS_ListNode<ListItem> (id, item, 0) { m_fileIndex = 0L;};

  inline void SetFileIndex(long index) { m_fileIndex = index; } ;

  // get utilities
  inline long GetFileIndex() { return this ? m_fileIndex : -1; };

private:
  long m_fileIndex;
};

#endif
