/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/include/avs/animator/GeomSave.h#1 $
*/
#ifndef _GEOMSAVE_H_
#define _GEOMSAVE_H_

#include <avs/animator/DiscCache.hxx>
#include <avs/animator/GDViewTraverser.hxx>
#include <avs/animator/GS_ListHeader.hxx>

//
// OM functions
//

#define GS_INIT_ANIMATION        "GSinit_animation"
#define GS_END_ANIMATION         "GSend_animation"
#define GS_ABORT_ANIMATION       "GSabort_animation"
#define GS_WRITE_GEOMETRY_LIST   "GSwrite_geometry_list"
#define GS_WRITE_GEOMETRY        "GSwrite_geometry"
#define GS_WRITE_CACHE           "GSwrite_cache"
#define GS_WRITE_XFORM_LIST      "GSwrite_xform_list"
#define GS_WRITE_XFORM           "GSwrite_xform"
#define GS_WRITE_PROPS_LIST      "GSwrite_props_list"
#define GS_WRITE_PROPS           "GSwrite_props"
#define GS_WRITE_MODES_LIST      "GSwrite_modes_list"
#define GS_WRITE_MODES           "GSwrite_modes"
#define GS_WRITE_TEXTURE_LIST    "GSwrite_texture_list"
#define GS_WRITE_TEXTURE         "GSwrite_texture"
#define GS_WRITE_TXTRXFORM_LIST  "GSwrite_txtrxform_list"
#define GS_WRITE_TXTRXFORM       "GSwrite_txtrxform"
#define GS_WRITE_FRAMELIST       "GSwrite_frame_list"
#define GS_WRITE_FRAME           "GSwrite_frame"
#define GS_WRITE_VIEW            "GSwrite_view"
#define GS_WRITE_CAMERA_LIST     "GSwrite_camera_list"
#define GS_WRITE_CAMERA          "GSwrite_camera"
#define GS_WRITE_OBJECT          "GSwrite_object"
#define GS_END_OBJECT            "GSend_object"
#define GS_END_FRAME             "GSend_frame"

class ListGenerator : public GDViewTraverser {
  friend class GeomSave;
 public:
  ListGenerator(OMobj_id id): GDViewTraverser(id) { m_status_max = 0 ;  m_status_count =0 ;};
  ~ListGenerator() { cleanUp();};

 private:
  virtual void inObject(GDobject *);

  void cleanUp();
  void save_cache_list(void *client_data, int id, GDcache_header *header);
  int save_geometry_cache_list(void *client_data, DiscFrameManager *discFrameManager);
  int save_xform_list(void *client_data);
  int save_props_list(void *client_data);
  int save_modes_list(void *client_data);
  int save_texture_list(void *client_data, DiscFrameManager *discFrameManager);
  int save_txtr_xform_list(void *client_data);
  void reset_list_curr_pointers();

  void setStatus();
  inline int updateStatus() {
    int Interrupt;
    if (m_status_max)
      OMstatus_check((m_status_count++ * 100)/m_status_max , NULL, &Interrupt);
    return Interrupt;
  }

  GS_ListHeader<GDcache_header> m_geometry_cache_list;
  GS_ListHeader<GDxform> m_xformList;
  GS_ListHeader<GDprops> m_propsList;  
  GS_ListHeader<GDmodes> m_modesList;
  GS_ListHeader<GDtexture> m_textureList;
  GS_ListHeader<GDxform> m_txtrXformList;

  int m_status_max;
  int m_status_count;
  int _Interrupt;
};

class GeomSave : public GDViewTraverser {
 public:

 public:
  GeomSave(OMobj_id id);
  ~GeomSave();

  void GSset_frameno(int frameno) { m_frameno = frameno;};
  void GSset_filename(char *filename) {
    if (filename) {
      if (m_filename)
        free(m_filename);
      m_filename = strdup(filename);
    }
  }
  void GSset_format(int format) {
    m_format = format;
  }
  void GSset_overwrite(int overwrite) {
    m_skip_overwrite_check = overwrite;
  }

  int GSsave_animation(GDview *view);

 private:
  //
  // 
  //

  virtual void inView();
  virtual void inCamera(GDcamera *);
  virtual void inFrame(GDframe *);
  virtual void inObject(GDobject *);
  virtual void outObject(GDobject *);

  void resetObjIdAssigner( ) { m_obj_id_assigner = 0;};
  int  getUniqueObjId() { return m_obj_id_assigner++;};

  //
  // generate our lists
  //
  ListGenerator m_listGenerator;
  int m_obj_id_assigner;
  
  //
  // state from Express
  //
  char     *m_filename;
  int      m_format;
  int      m_frameno;
  int      m_skip_overwrite_check;

  //
  // state from writer
  //
  void *m_client_data;
};

#endif


