//                      Copyright (c) 1993 by
//                      Advanced Visual Systems Inc.
//                      All Rights Reserved
//
//      This software comprises unpublished confidential information of
//      Advanced Visual Systems Inc. and may numt be used, copied or made
//      available to anyone, except in accordance with the license
//      under which it is furnished.
//
//      This file is under Perforce control
//      $Id: //depot/express/fcs70/include/avs/animator/ImagForm.h#1 $
//

#ifndef XP_ANIMATOR_IMAGEFORM_H
#define XP_ANIMATOR_IMAGEFORM_H

/*

	Object:		ImageForm, ARGB/32-bit image

	Function:	Generic Image Form for Image Capture/Flipbook
			Used in AVI and MPEG compression

      Description:  An object used in AVS/Express that is able to retrieve an
			image from a view, store it to disk or in memory, and
			play it back into the view.

*/

#include <avs/port.h>
#include <avs/gd.h>

class ImageForm
{
	unsigned int	m_Width;	// Width in pixels of bitmap
	unsigned int	m_Height;	// Height in pixels of bitmap
	unsigned char	*m_Pixels32;	// Pointer to bit pixels of bitmap ARGB
	int		m_IsOnDisk;	// Is File on Disk?
	char		m_File[256];	// Filename if on disk

public:
	// Constructors/Destructors
	ImageForm();			// General Constructor
	virtual ~ImageForm();		// General Destructor

	// Operations
	void PutInMemory();		// Put Image In Memory
	void PutOnDisk();		// Put Image on Disk
	void PutFrame(GDview *v);	// BLT Image to Current View
	void SetName(const char *c);		// Set Filename

	// Data Accumulation
	void AttachRawData(unsigned char *ptr,		// Attach Raw Bits
				int Width, int Height, int CopyOnly=0);
	void GrabFrame(GDview *p=NULL);		// Capture Frame From View

	// Access
	unsigned char * GetPixels();		// Grab Raw Pixel Data
	unsigned char * GetPixel(int x, int y);	// Grab Specific Pixel
	unsigned int GetHeight();		// Get Image Height
	unsigned int GetWidth();		// Get Image Width
	int GetByteSize();			// Get Size in BYTE's
	int Good();				// Is this Image valid?

	// Operators
	unsigned char * operator()(int x, int y); // Return pointer to Matrix Pixel
	ImageForm & operator=(ImageForm &other);	// Copy operator
};

#endif
