/*
                        Copyright (c) 1997 by
                        Advanced Visual Systems Inc.
                        All Rights Reserved

        This software comprises unpublished confidential information of
        Advanced Visual Systems Inc. and may not be used, copied or made
        available to anyone, except in accordance with the license
        under which it is furnished.

        This file is under Perforce control
        $Id: //depot/express/fcs70/include/avs/animator/LCubic.h#1 $
*/

#ifndef __LCUBIC_H
#define __LCUBIC_H

/*

	Object:			Cubic Spline Implementation

	Author:			Kyle Lussier (lussier@inside.ch / klussier@avs.com)
					Enhanced Implementation for AVS/Express

					Original Implementation in the Manning/Prentice-Hall book:
					"POWER-3D: High-Speed 3D Graphics in Windows 95/NT"

	Description:	Implements 3rd Degree/Natural Cubic Spline Interpolation

	Body:  

	Implements Third Degree Cubic Spline Interpolation for a set of numbers.
	If set of numbers changes, please make a function call to Build();

	This object calculates a collection of curves (splines) that can be
	used piecewise to interpolate along a series of points.
	
		A[i] + B[i]*x + C[i]*x^2 + D[i]*x^3

	The object calculates the coeficients for A, B, C, D for all curves
	such that each curve passes through a given point.  The collection of
	curves are then used piecewise as a continuous interpolative model.

	Date Started:	May 29, 1997

*/

#include "LInterp.h"

class LCubicInterpolator : public LInterpolator  
{
// Polynomial Coefficients
	double *A;		// range i=1.. (n)
	double *B;		// range i=1.. (n)
	double *C;		// range i=1.. (n)
	double *D;		// range i=1.. (n)

public:
	virtual void SetTension(int bi, double c);
	double operator()(unsigned i, double x);
	LCubicInterpolator();
	virtual ~LCubicInterpolator();

	virtual int GetType() { return LCubic; };
	virtual int Build();						// Abstract for build evaluator
	virtual double Evaluate(double time, double curvy=0);		// Calculates Interpolation
	virtual void Destroy();
};

#endif
