/*
                        Copyright (c) 1997 by
                        Advanced Visual Systems Inc.
                        All Rights Reserved

        This software comprises unpublished confidential information of
        Advanced Visual Systems Inc. and may not be used, copied or made
        available to anyone, except in accordance with the license
        under which it is furnished.

        This file is under Perforce control
        $Id: //depot/express/fcs70/include/avs/animator/LRotInt.h#1 $
*/

#ifndef __LRotationInterpolator_H
#define __LRotationInterpolator_H

/*

	Object:			Rotation Interpolator

	Author:			Kyle Lussier (lussier@inside.ch / klussier@avs.com)
					Enhanced Implementation for AVS/Express

	Description:	N-Dimensional Spline Object for use in AVS/Express Animator
					and Page Flip Book.

	Body:  

	This object performs quaternion based rotation interpolation for a
	collection of matrices.

*/

#include "LSpline.h"

class LRotationInterpolator
{
	LSpline m_Scales;
	LSpline m_Rotates;

	float *m_Mats;
	unsigned m_N;

public:
	void SetData(LSpline &s);
	void Evaluate(float time, float outmat[4][4]);
	void Set4X4Matrices(float *mats, int n, int LCurviness, int bi, double c);
	LRotationInterpolator();
	virtual ~LRotationInterpolator();

};

#endif
