/*
			Copyright (c) 1997 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/include/avs/animator/animator.h#1 $
*/

/* Header file for the animator subsystem */

/*---------------------------------------------------------------------*/

/* Prevent the contents of this file from being included more than once */

#ifndef XP_ANIMATOR_INCLUDED
#define XP_ANIMATOR_INCLUDED

#include <avs/om.h>
#include <avs/cxxutl/ptrlist.hxx>

class InterpolatorClass;

class AnimObjBase {
public:
        AnimObjBase() {
          _objId = OMnull_obj;
        }

	virtual ~AnimObjBase() {
          releaseObjId();
        }

	int data_type;
	int found;
        char path[128];
   	char name[128];

	// Sorting operators need to be provided, even
	// if not used.  Following are dummies.
	int operator >(const AnimObjBase &o ) {
	    return 1;
	}
	int operator <=(const AnimObjBase &o ) {
	    return 0;
	}

        inline void setObjId(OMobj_id objId)  {
          // if we are referencing an existing object release it
          releaseObjId();

          _objId = objId;

          // ensure the OM knows we have the object
          // to prevent it from being deleted
          OMadd_to_refcnt(_objId,1);
        }

        inline OMobj_id getObjId() {
          return _objId;
        };

private:
        inline void releaseObjId() {
          if (!OMis_null_obj(_objId))
            OMdestroy_obj(_objId, 0);
        }

	OMobj_id _objId;
};

template <class TYPE>
class AnimObj : public AnimObjBase {
public:
    AnimObj(TYPE v) : val(v) { }
    TYPE val;
};

// val must be allocated with "new TYPE []"
template <class TYPE>
class AnimArrPtrObj : public AnimObj<TYPE> {
public:
    AnimArrPtrObj(TYPE v) : AnimObj<TYPE>(v) { }
   ~AnimArrPtrObj( ) { delete [] this->val; }
};


typedef AnimObjBase  *AnimObjPtr;



class AnimatorClass {
private:

protected:

public:

    // Setup/Initialization
    // Time Functions
    int getFirstTime(OMobj_id animCntrlId, float *firstTime);
    int getTime(OMobj_id animCntrlId, xp_long position, float *thisTime);
    int getInterpValuesArraySize(AnimObjBase *animObjPtr, OMobj_id interpGrpId, xp_long *valuesSize);
    int timeExists(OMobj_id animCntrlId, float thisTime, xp_long *position);
    int findPrevTime(OMobj_id animCntrlId, float currentTime, float *prevTime);
    int findTimeInKeysArray(AnimObjBase *animObj, OMobj_id interpGrpId, float thisTime, xp_long *position);
    int findTimeInKeysArray(OMobj_id interpolatorId, float interpTime, xp_long *position);

    // Array Functions - eventually will move all functions in array.cxx to animator.cxx
    int addExtraValuesToArray(AnimObjBase *animObjPtr,OMobj_id interpGrpId,xp_long position);
    int addFirstValue(AnimObjBase *animObjPtr, OMobj_id animCntrlId, OMobj_id interpGrpId,OMobj_id countId);
    int addPrevValue(AnimObjBase *animObjPtr, OMobj_id animCntrlId, float currentTime, OMobj_id interpGrpId,OMobj_id countId);
    int moveArrayValue (AnimObjBase *animObjPtr, OMobj_id interpGrpId, xp_long position, xp_long newPosition);
    int moveArrVal(int *intValuesArr, OMobj_id valuesId, xp_long totalElements, xp_long position, xp_long newPosition, xp_long numKeys);
    int moveArrVal(float *floatValuesArr, OMobj_id valuesId, xp_long totalElements, xp_long position, xp_long newPosition, xp_long numKeys);
    int moveArrVal(double *doubleValuesArr, OMobj_id valuesId, xp_long totalElements, xp_long position, xp_long newPosition, xp_long numKeys);
    int moveArrVal(char **charValuesArr, OMobj_id valuesId, xp_long totalElements, xp_long position, xp_long newPosition, xp_long numKeys);
#ifdef WORDLENGTH_64
    int moveArrVal(xp_long *longValuesArr, OMobj_id valuesId, xp_long totalElements, xp_long position, xp_long newPosition, xp_long numKeys);
#endif
    int moveArrayTime (float *timeArray, xp_long numkeys, float oldTime, float newTime, xp_long *position, xp_long *newPosition);
    int copyFromValuesArray (AnimObjBase *animObjPtr,OMobj_id interpGrpId,xp_long position, xp_long newPosition);
    int copyArrVal(float *floatValuesArr, xp_long totalElements, xp_long numKeys, xp_long position, xp_long newPosition);
    int copyArrVal(int *intValuesArr, xp_long totalElements, xp_long numKeys, xp_long position, xp_long newPosition);
    int copyArrVal(char **charValuesArr, OMobj_id valuesId, xp_long totalElements, xp_long numKeys, xp_long position, xp_long newPosition);
    int copyArrVal(double *doubleValuesArr, xp_long totalElements, xp_long numKeys, xp_long position, xp_long newPosition);
#ifdef WORDLENGTH_64
    int copyArrVal(xp_long *longValuesArr, xp_long totalElements, xp_long numKeys, xp_long position, xp_long newPosition);
#endif
    int deleteUIEditorDialog(OMobj_id animCntrlId);
    void getSubArray (float *valuesArr, xp_long position, xp_long numKeys, float *array);
    void getSubArray (double *valuesArr, xp_long position, xp_long numKeys, double *array);
    void getSubArray (int *intValuesArr, xp_long position, xp_long numKeys, int *intArray);
#ifdef WORDLENGTH_64
    void getSubArray (xp_long *valuesArr, xp_long position, xp_long numKeys, xp_long *array);
#endif
    int getTimeArray (AnimObjBase *animObjPtr, OMobj_id interpGrpId, float **keysArr, xp_long *numKeys);
    int getTimePosition (OMobj_id keysId, float time, xp_long *numKeys);
    int getInterpList(OMobj_id interpGrpId, float thisTime, char ***interpList, xp_long *numKeys);
    int setInterpList(OMobj_id interpGrpId, OMobj_id animCntrlId, char** interpList, xp_long numListItems);
    int getInterpIdAndName(OMobj_id interpGrpId, char **interpList, xp_long interpListIndex,OMobj_id *interpolatorId, char *interpName);
    int getInterpTimesList(OMobj_id interpId, float **keysArray, xp_long *timesListSize);
    int getInterpValues(OMobj_id interpId, float interpTime, xp_long *values);
    int getInterpType(UtPtrList<AnimObjBase> & animObjDbList, char *interpName, int *valuesType, int *nDims,xp_long *dimsSizes);
    int getInterpDimensions(UtPtrList<AnimObjBase> & animObjDbList, char *interpName, int *nDims, xp_long *dimsSizes);
    int getInterpValues(float interpTime, OMobj_id interpId, UtPtrList<AnimObjBase> & animObjDbList, char *interpName, float **valuesArray, xp_long *valuesSize, xp_long *unitElements, int *type);
    int getInterpUIValues(OMobj_id animCtrlId, float *valuesArr, xp_long unitElements, InterpolatorClass *Interpolator, int *rotMethod, int *interpType);
    int getInterpUIValues(OMobj_id animCtrlId, int *valuesArr, xp_long unitElements, InterpolatorClass *Interpolator, int *interpType);
    int getUnitElements(int nDims, xp_long *dimsSizes,xp_long *unitElements);
    int setInterpUIValues(OMobj_id interpId, int valuesType, float interpTime,OMobj_id winAppId, InterpolatorClass *Interpolator);
    int setUIFormat(OMobj_id animCtrlId, int valuesType, int nDims, xp_long *dimsSizes);
    int setInterpUIValues(OMobj_id animCtrlId,float *valuesArr, xp_long unitElements, xp_long position, InterpolatorClass *Interpolator,int rotMethod, int interpType);
    int setInterpUIValues(OMobj_id animCtrlId,int *valuesArr, xp_long unitElements,xp_long position, int interpType);
    int setInterpValues(OMobj_id interpolatorId, float *valuesArr, int valuesType, OMobj_id animCtrlId, float interpTime, int rotMethod, int interpType);
    int setInterpValues(OMobj_id interpolatorId, int *valuesArr, int valuesType, OMobj_id animCtrlId, float interpTime, int interpType);
    int updateInterpolatorList(OMobj_id interpGrpId,OMobj_id animCntrlId,float currentTime );
    int scaleTimesArray(AnimObjBase *animObjPtr, OMobj_id interpGrpId,float scaleBeginTime,float scaleEndTime,float scaleValue);
    int scaleValuesArray(AnimObjBase *animObjPtr, OMobj_id interpGrpId, xp_long beginPosition, xp_long endPosition, float scaleValue);
    int scaleFrameTimes(OMobj_id animCntrlId, float scaleBeginTime, float scaleEndTime, float scaleValue);
    void scaleArray(float *floatValuesArr, xp_long beginPosition, xp_long endPosition, float scaleValue);
    void scaleArray(int *intValuesArr, xp_long beginPosition, xp_long endPosition, float scaleValue);
    void scaleArray(short *shortValuesArr, xp_long beginPosition, xp_long endPosition, float scaleValue);
    void scaleArray(double *doubleValuesArr, xp_long beginPosition, xp_long endPosition, float scaleValue);
    void scaleArray(unsigned char *byteValuesArr, xp_long beginPosition, xp_long endPosition, float scaleValue);
#ifdef WORDLENGTH_64
    void scaleArray(xp_long *longValuesArr, xp_long beginPosition, xp_long endPosition, float scaleValue);
#endif
    int getBeginPositionInArray( AnimObjBase *animObjPtr, OMobj_id interpGrpId, float time, xp_long *position);
    int getEndPositionInArray( AnimObjBase *animObjPtr, OMobj_id interpGrpId, float time, xp_long *position);
    // conversion functions
    void anglesToMatrix(double radians[3], float rot_matrix[4][4]);
    int  matrixToAngles(double rot_matrix[4][4], double radians[3]);
    int  checkzero(double val);
};

/*--------------------------------------------------------------------*/
/*                       Function prototypes                          */
/*--------------------------------------------------------------------*/

#ifdef __cplusplus  /* Do not leave open across includes */
extern "C" {        /* For C++ V2.0 */
#endif
// array functions

int addToValuesArray (AnimObjBase *animObjPtr, OMobj_id intrpGrpId, xp_long position);
int addToTimesArray (AnimObjBase *animObjPtr, OMobj_id intrpGrpId, float nextTime, xp_long *position);
int addToIntArray (int *intValuesArr, OMobj_id valuesId, xp_long totalElements, xp_long position, xp_long numKeys, int *newIntValArray);
int addToFloatArray (float *valuesArr, OMobj_id valuesId, xp_long totalElements, xp_long position, xp_long numKeys, float *newValArray);
int addToDoubleArray (double *valuesArr, OMobj_id valuesId, xp_long totalElements, xp_long position, xp_long numKeys, double *newValArray);
int addToByteArray (unsigned char *valuesArr, OMobj_id valuesId, xp_long totalElements, xp_long position, xp_long numKeys, int *newIntValArray);
int addToLongArray (xp_long *valuesArr, OMobj_id valuesId, xp_long totalElements, xp_long position, xp_long numKeys, xp_long *newLongValArray);
int deleteFromTimesArray (AnimObjBase *animObjPtr, OMobj_id intrpGrpId, float currentTime, xp_long *position);
int deleteFromValuesArray (AnimObjBase *animObjPtr, OMobj_id intrpGrpId, xp_long position);
int deleteFromIntArray (OMobj_id valuesId, int *newValuesArr, xp_long valuesSize,xp_long position, xp_long numKeys);
int deleteFromFloatArray (OMobj_id valuesId, float *newValuesArr, xp_long valuesSize,xp_long position, xp_long numKeys);
int deleteFromDoubleArray (OMobj_id valuesId, double *newValuesArr, xp_long valuesSize,xp_long position, xp_long numKeys);
int deleteFromStringArray (OMobj_id valuesId, char ***tempValuesPtr, xp_long valuesSize, xp_long position);
int deleteFromLongArray (OMobj_id valuesId, xp_long *newValuesArr, xp_long valuesSize,xp_long position, xp_long numKeys);

int getStringArray (OMobj_id valuesId, char ***tempValuesPtr, xp_long valuesSize, xp_long position);
int insertInStringArray (OMobj_id valuesId, char ***newStringValuesPtr, xp_long numKeys, xp_long position, char *newStringValPtr);
int replaceStringArray (OMobj_id valuesId, char **newStringValuesPtr, xp_long valuesSize);

int incrementArraySizes (AnimObjBase *animObjPtr, OMobj_id intrpGrpId, OMobj_id countId);

// find functions

int find (OMobj_id parentId, int subObjArrayIndex, OMobj_id objId, UtPtrList<AnimObjBase> & animObjDbList, int firstFind);
int findApp (OMobj_id objId, OMobj_id *appId);
int findAndDestroy (OMobj_id winAppId, UtPtrList<AnimObjBase> & animObjDbList, OMobj_id interpGrpId);
int findTop (OMobj_id objId, int *level);
void clearFoundFlag (const UtPtrList<AnimObjBase> &animObjDbList);
void removeNotFound (UtPtrList<AnimObjBase> &animObjDbList);

// database functions

int inADB (char *objName, const UtPtrList<AnimObjBase> &animObjDbList );

// notify functions

int addNotify (OMobj_id animCntrlId, OMobj_id winAppId);
int deleteNotify (OMobj_id animCntrlId, OMobj_id winAppId);

#ifdef __cplusplus
}  /* End extern "C" */
#endif

/*--------------------------------------------------------------------*/

#endif /* XP_ANIMATOR_INCLUDED */
/* DON'T ADD ANYTHING AFTER THIS #endif */
