/*
 * interface functions for GFA file format
 */
#include <avs/gd.h>

extern "C" void *GFAinit_animation(char *, int, int, int, int);
extern "C" int GFAend_animation(void *);
extern "C" void GFAabort_animation(void *);

extern "C" int GFAwrite_geometry_list(void *, int ngeoms);
extern "C" int GFAwrite_geometry(void *, int id, int ncaches);
extern "C" int GFAwrite_cache(void *, GDcache *);

extern "C" int GFAwrite_xform_list(void *, int nxforms);
extern "C" int GFAwrite_xform(void *, int id, GDxform *);

extern "C" int GFAwrite_props_list(void *, int nprops);
extern "C" int GFAwrite_props(void *, int id, GDprops *);

extern "C" int GFAwrite_modes_list(void *, int nmodes);
extern "C" int GFAwrite_modes(void *, int id, GDmodes *);

extern "C" int GFAwrite_texture_list(void *, int ntextures);
extern "C" int GFAwrite_texture(void *, int id, GDtexture *);

extern "C" int GFAwrite_txtrxform_list(void *, int ntxrtxforms);
extern "C" int GFAwrite_txtrxform(void *, int id, GDxform *);

extern "C" int GFAwrite_camera_list(void *, int nCameras);
extern "C" int GFAwrite_camera(void *, GDcamera *);

extern "C" int GFAwrite_frame_list(void *, int nFrames);
extern "C" int GFAwrite_frame(void *, GDframe *);
extern "C" int GFAwrite_object(void *, int obj_id, 
		  int geom_id, int xform_id, int props_id, int modes_id,
		  int txtr_id, int txtr_xform_id, GDobject *);

