/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/include/avs/animator/gfaFile.hxx#1 $
*/
#ifndef _GFA_FILE_HXX_
#define _GFA_FILE_HXX_

//
// GFAFile - GFA file generator class
//
#include <sys/stat.h>
#ifdef WIN32
#include <io.h>
#else
#include <stdio.h>
#include <unistd.h>
#endif
#include <fcntl.h>

#include <avs/animator/gfa.h>

class GFAFile {
public:
  enum GFABlockType {
	 GFA_HEADER = 0, GFA_GEOM_HEADER = 1,
	 GFA_GEOM = 2, GFA_CACHE = 3,
	 GFA_XFORM_HEADER = 4, GFA_XFORM = 5,
	 GFA_PROPS_HEADER = 6, GFA_PROPS = 7,
	 GFA_MODES_HEADER = 8, GFA_MODES = 9,
	 GFA_TXTRXFORM_HEADER = 10, GFA_TXTRXFORM = 11,
	 GFA_TXTR_HEADER = 12, GFA_TXTR = 13,
	 GFA_CAMERA_HEADER = 14, GFA_CAMERA = 15,
	 GFA_FRAME_HEADER = 16, GFA_FRAME = 17,
	 GFA_OBJECT = 18, GFA_EOF = 19
  };

  GFAFile();
  ~GFAFile();
  void Abort();
  int OpenFile(char *, int mode = RDONLY, int compress = 0);
  int CloseFile();
  void SetFd(int fd) { _fd = fd; OpenFile(NULL, 0, 0); };
  inline int GetFd() { return _fd;};
  inline long getFileIndex() { flush(); return TELL(GetFd());};
  inline long setFileIndex(long fileIndex) { flush(); return SEEK(GetFd(), fileIndex, SEEK_SET );};
  inline long setFileIndexEof() { flush(); return SEEK(GetFd(), 0, SEEK_END);};
  int flush() { return GFAunixio_flush (_GFAunixio);};

protected:
  //
  // file
  //
  char    *_filename;
  int     _fd;

  char    *_GFAunixio;
  static const int _proto_version;

  //
  // magic number and check byte
  //
  static int _magic;

  //
  // general purpose message buffer
  //
  static char _errMsg[1024];

  //
  // debug flag
  //
  int _GFA_debug;
};

#endif
