/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/include/avs/arr.h#1 $
*/

#ifndef ARR_INCLUDED
#define ARR_INCLUDED

#include <avs/port.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef struct _ARRtype {
   char name[64];
   void *(*palloc) (size_t, char *);/* Takes length and data ptr */
   void *(*prealloc) (void *, size_t, char *);
   void (*pfree) (void *, char *);/* Free's a previously allocated ptr */
   /* Reads an array from the connection */
   int (*pread) (void *, int *, char **, xp_long *, int);
   /* Writes an array to the connection */
   int (*pwrite) (void *, int, char *, xp_long, int);
   unsigned int code;
   struct _ARRtype *next;
} ARRtype;

typedef struct _ARRarray {
   ARRtype *arr_type;
   int	   d_type;
   void	   *d_ptr;
   size_t  d_len;
   unsigned int     refcnt:28;
   unsigned int     trace:1;
   char    *info;
   int (*update) (void * arg, void * ptr, int, size_t, int);
   void    *upd_arg;
   struct _ARRarray *next;
} ARRarray;

/* Flags to the ARRupdate routine */
#define ARR_NOT_MODIFIED  2
#define ARR_LAST_UPDATE	  1

void	ARRinit (void);
int	ARRset_trace (void *, int);
int	ARRget_trace (void *);
void	ARRset_default_type (ARRtype *);
void    ARRset_comm_funcs (int (*)(void *, int, char *),
			   void (*)(void *, int),
			   void (*)(void *, xp_long),
			   int (*)(void *, int, char **, xp_long),
			   void (*)(void *, int, char *, xp_long) );
ARRtype *ARRnew_type (const char *,
			void *(*)(size_t, char *),
			void *(*)(void *, size_t, char *),
			void (*)(void *, char *),
			int (*)(void *, int *,char **, xp_long *, int),
			int (*)(void *, int, char *, xp_long, int));

ARRtype *ARRname_to_type (const char *);
ARRtype *ARRcode_to_type (unsigned int);

void *	ARRalloc (ARRtype *, int, size_t, char *);
void *	ARRalloc_f (ARRtype *, int, size_t, char *, const char *, int);
void *	ARRrealloc (void *, int, size_t, char *);
void *	ARRrealloc_f (void *, int, size_t, char *, const char *, int);
void	ARRincr_refcnt (void *);
void	ARRincr_refcnt_f (void *, const char *, int);
void 	ARRfree (void *);
void 	ARRfree_f (void *, const char *, int);
void	ARRfree_no_update_f (void *, const char *, int);
void    ARRupdate (void *, int final);
int	ARRnew_managed (ARRtype *, void *, int, size_t, char *);
int	ARRnew_unmanaged (void *, int, size_t, char *);
int	ARRvalid (void *);
int	ARRarray_read (void *conn, int *typep, char **pptr, xp_long *lenp, int mode);
#ifdef WORDLENGTH_64
int	ARRarray_read_n (void *conn, int *typep, char **pptr, int *lenp, int mode);
#endif
int	ARRarray_write (void *conn, int type, char *ptr, xp_long len, int mode);
int	ARRrefcnt (void *);
void	ARRexit (void);
size_t  ARRget_alloc_size (int d_type, size_t lower, size_t upper);
size_t  ARRget_alloc_size_total (void);

int  ARRhas_update_func (void *ptr);
void ARRset_update_func (void *ptr, 
			 int (*func) (void *, void *, int, size_t, int),
			 void *upd_arg);

#if defined(WORDLENGTH_64) && !defined(XP_WIDE_API)
   #define ARRarray_read ARRarray_read_n
#endif

#define ARR_ARRAY_RD	0
#define ARR_ARRAY_WR	1
#define ARR_ARRAY_RW	2

/* These macros enable the array routines to report from where
 * they are being called.
 */

#define ARRalloc(arr_type,d_type,d_len,arr_info) \
    ARRalloc_f((arr_type), (d_type), (d_len), (arr_info), \
               __FILE__, __LINE__)
#define ARRrealloc(ptr,d_type,d_len,arr_info) \
    ARRrealloc_f((ptr), (d_type), (d_len), (arr_info), \
                 __FILE__, __LINE__)
#define ARRfree(ptr) ARRfree_f((ptr), __FILE__, __LINE__)
#define ARRfree_no_update(ptr) \
	ARRfree_no_update_f((ptr), __FILE__, __LINE__)
#define ARRincr_refcnt(ptr) ARRincr_refcnt_f(((char*)ptr), __FILE__, __LINE__)

#ifdef __cplusplus
} /* End of extern "C" */
#endif

#endif
