/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved
	
	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.
	
	This file is under Perforce control
	$Id: //depot/express/fcs70/include/avs/array.h#1 $
*/
#if !defined(array_h)
#define array_h

#include <assert.h>


class DBArray {

public:

// Construction
	DBArray(xp_long growBy = 0);

// Attributes
	xp_long     size() const;
	xp_long     upperBound() const;
	void	size(xp_long newSize, xp_long growBy = -1);

// Operations
	// Clean up
	void    freeExtra();
	void	removeAll();

	// Accessing elements
	void*	atGet(xp_long index) const;
	void	atSet(xp_long index, void* newElement);
	void*&	elementAt(xp_long index);
	xp_long	find(void * element);

	// Potentially growing the array
	void	atSetGrow(xp_long index, void* newElement);
	xp_long	add(void* newElement);

	// Stack-like operations
	void 	push (void* newElement);
	void*	pop ();

	// overloaded operator helpers
	void*	operator[](xp_long index) const;
	void*&	operator[](xp_long index);

	// Operations that move elements around
	void	insertAt(xp_long index, void* newElement, xp_long count = 1);
	void	insertAt(xp_long startIndex, DBArray* newArray);
	void	removeAt(xp_long index, xp_long count);
	void *	removeAt(xp_long index);
	void *	remove(void *element);

// Implementation
protected:
	void**	 _data;       // the actual array of data
	xp_long	_size;	      // # of elements (upperBound - 1)
	xp_long	_maxSize;     // max allocated
	xp_long	_growBy;      // grow amount

public:
	~DBArray();
};

// Inline Functions

inline	xp_long
DBArray::size() const { return _size; }

inline	xp_long     
DBArray::upperBound() const { return _size-1; }

inline void	
DBArray::removeAll() { DBArray::size(0); }

	// Accessing elements
inline void * 
DBArray::atGet(xp_long index) const
{
	assert(index >= 0 && index < _size);
	return _data[index];
}

inline void 
DBArray::atSet(xp_long index, void* newElement)
{
	assert(index >= 0 && index < _size);
	_data[index] = newElement;
}

inline void*&
DBArray::elementAt(xp_long index)
{
	assert(index >= 0 && index < _size);
	return _data[index];
}

inline xp_long
DBArray::add(void* newElement)
{
	xp_long index = _size;
	atSetGrow(index, newElement);
	return index;
}

	// Stack-like operations
inline void	
DBArray::push (void* newElement)
{
    add(newElement);
}

inline void*
DBArray::pop ()
{
    return removeAt(_size - 1);
}

        // overloaded operator helpers

inline void*
DBArray::operator[](xp_long index) const { return atGet(index); }

inline void*&
DBArray::operator[](xp_long index) { return elementAt(index); }

#endif
/////////////////////////////////// EOF //////////////////////////////////////
