/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/include/avs/avs_conn.h#1 $
*/

#ifndef _NFILE
#include <stdio.h>
#endif

#include <avs/port.h>

#ifndef MSDOS
#include <rpc/types.h>

/*
 * On other systems, sys/types.h is automatically included by
 * rpc/types.h.  However, on the IBM, rpc/types.h does not
 * have this property.
 */
#include <sys/types.h>

/*
 * On other systems, sys/types.h notices if it was included before
 * and skips over its contents.  However, on the Cray, sys/types.h
 * does not have this property.  X11/Xlib.h already has a kludge for
 * this.  I added the same thing to lui.h and below.
 */

#if _CRAY		/* Kludge until UNICOS 6.0 is available. */
#define __TYPES__ 1
#endif

#include <rpc/xdr.h>

#else	/* MSDOS */
#include <winsock.h>
#include "pc_xdr\types.h"
#include "pc_xdr\xdr.h"
#endif

/*
 * The AVSclient_protocol table contatins a description of each kind of
 * protocol to be used in communicating from external modules to the AVS
 * kernel.
 */

struct AVSclient_protocol {
	xp_long (*read_fun)();
	xp_long (*write_fun)();
	int (*sync_fun)();
	int (*destroy_fun)();
	int (*select_fun)();	/* Add/delete select items */
	int (*incr_fun)();
	int (*fd_fun)();	/* Returns a file descriptor */
};

/* The first argument to the select function is whether to add or delete */
/* the select */

#define ADD_SELECT 1
#define DEL_SELECT 2

/*
 * The following definitions are the calls in the RPC protocol.  These are
 * used regardless of the underlying connection protocol.
 *
 * History:
 *	1 - original.
 *	2 - ?
 *	4 - I think AVS 2.0 was shipped with this version.
 *	6 - 6/90 - Fields may be in shared memory.
 *	7 - 7/90 - Send field extents and value min/max thru socket.
 *	8 - 7/90 - Transmit XDR rather than native format.
 *	9 - 7/90 - write_module sends host name.
 *     10 - 9/90 - New geometry file format.
 *     11 - 9/90 - Add units to field type.
 *     12 - 9/90 - AVSmodify_parameter - pass flags
 *     13 - 9/90 - Multiple Module Support, module user flags, spid option
 *		   (AVS3 GS Beta shipped)
 *     14 - 11/90 - Possibly larger points array for uniform fields.
 *		    (AVS3 Titan Beta shipped)
 *     15 - 2/91 - Modules send back both logical and actual host names.
 *		   (Shortly before final AVS 3 freeze.)
 *     16 - 6/91 - Added new data representation command.  tcp_descriptor
 *		    structure indicates whether XDR translation is necessary.
 *		   (In DEC AVS 3 and most non-Stardent AVS 3.1)
 *     666 - 9/91 - The BEASTly demo version for Sun CDWARE
 *     17 - 9/91 - Add ACK for sending data to or from coroutine. (bugr 7016)
 *		   (In HP version)
 *     18 - 10/91 - Direct module-to-module communications.
 *     19 - 11/91 - Ability to send inputs explicitly (upstream data bug)
 *     20 - 11/91 - process group is sent during read/write module
 * 		    "feature" masks exchanged during initialization
 * 		    connection data for port specific implementations.
 *		    (AVS 3.5 Stellar GS beta shipped 12/91)
 *     21 - 12/91 - jjv believes we gave this version to Dec for VMS stuff
 *     22 - 12/91 - added "mesh_id" feature to data types
 *     23 -  1/93 - send ACK from kernel side on PROC_ID read; module side
 *                  waits for this before exiting.  A SunOS 5.1 (and generic
 *                  SVR4?) problem: module exited before kernel completed
 *                  read.
 */

#ifdef AVS_DEMO
#define AVS_PROTO_VERSION  666	/* the mark of the beast */
#else
#define AVS_PROTO_VERSION  23	/* current protocol version */
#endif

#define AVS_FEATURE_MASK 0

#define AVS_PROC_ID  	1	/* server id request */
#define AVS_PROC_CALL	2	/* call a module */
#define AVS_PROC_DELETE	3	/* delete a module */
#define AVS_PROC_CORGET	4	/* get coroutine args */
#define AVS_PROC_CORSEND 5	/* send coroutine output */
#define AVS_PROC_CORWAIT 6	/* wait for param/input change */
#define AVS_PROC_COREXEC 7	/* wait for the flow exec to empty */
#define AVS_PROC_STOP	8	/* tells client to destroy module */
#define AVS_PROC_CALLBACK 9	/* response/coroutine only--starts a callback */
#define AVS_PROC_INSTANCE 10	/* tells module to create a new mod instance */
#define AVS_PROC_OUTSEND 11	/* tells module to send an output port */
#define AVS_PROC_CORSYNC 12   	/* tells kernel to set sync mode of coroutine */
#define AVS_PROC_CORCHANGED 13  /* mark coroutine module as changed */
#define AVS_PROC_CORCLEAR 14    /* clear a coroutine wait event */
#define AVS_PROC_DATAREP 15	/* exchange data representations */
#define AVS_PROC_SENDDIRECT 16	/* send output directly to downstream module */
#define AVS_PROC_INITDIRECT 17	/* initial greeting for direct communications */
#define AVS_PROC_DIRECTDATA 18	/* direct module-to-module data transfer */
#define AVS_PROC_INPREC     19  /* receive an input port from the kernel */
#define AVS_PROC_DYNLOAD    20	/* Dynamic Module Load request (DEC) */

/*
 * The following definitions define the callback protocol.
 */

#define AVS_CALLBACK_MESSAGE  1	/* The module wants to communicate an error/warning */
#define AVS_CALLBACK_VISIBILITY 2        /* Make a widget visible/invisible */
#define AVS_CALLBACK_PARAMETER_UPDATE 3 /* Update parameter, widget */
#define AVS_CALLBACK_COMMAND  4 /* Sending a CLI command to kernel */
#define AVS_CALLBACK_STATUS   5 /* Updating status indicator */
#define AVS_CALLBACK_XCTR_CREATE 6 /* Create a container */
#define AVS_CALLBACK_XCTR_LOOKUP 7 /* Lookup a container from a window */
#define AVS_CALLBACK_XCTR_DESTROY 8 /* Destroy a container */
#define AVS_CALLBACK_XCTR_LABEL 9 /* Update a container label */

/* The ways in which a library executable can be invoked */

#define INVOKE_IDENTIFY	1
#define INVOKE_INSTANCE 2
#define INVOKE_COROUTINE 3


/* Structure created by AVStcp_create and passed around everywhere. */
/* Actually it should it shouldn't be called "tcp_..." because it is */
/* more general purpose and nearly all can be used for other transport */
/* mechanisms. */

struct tcp_descriptor {
	int s;                  /* socket file number */
	char *wbuf;             /* the write buffer */
	int wf, wb;             /* front and back of the write buffer */
	char *rbuf;             /* the read buffer */
	int rf, rb;             /* front and back of the read buffer */
	xp_long (*func)();          /* function to call for select */
	int arg;                /* argument to func */
	struct tcp_descriptor *sel_next; /* next function on the select list */

	XDR read_xdrs;		/* The XDR handle for reads. */
	XDR write_xdrs;		/* The XDR handle for writes. */

	enum { TCP_LOCAL,	/* Other end is on same machine. */
		TCP_REMOTE,	/* Other end is on different machine. */
		TCP_UNKNOWN 	/* Don't know yet. */
	} other_end;
	int refcnt;		/* Number of references to this descriptor */

	int debug_level;	/* Used to record all socket reads and */
				/* writes in a file. */
				/* 1 = just the sizes of data. */
				/* 2 = all the data too. */
	FILE *debug_fp;		/* File for use with above. */

	int bypass_xdr_char;	/* May be possible to bypass XDR layer */
	int bypass_xdr_int;	/* when both sides have same data */
	int bypass_xdr_float;	/* representation. */
	int bypass_xdr_double;
	int bypass_xdr_int64_t;

	int proto_vers;		/* Highest protocol version understood */
				/* by both ends of the socket. */

	int other_host_addr;	/* Host address on other end of socket. */
	int other_pid;		/* Process id on other end of socket. */

	struct tcp_descriptor *next_open;	/* Used to maintain */
				/* linked list of all open sockets.  */
				/* AVStcp_create links new item into */
				/* existing */
				/* list. */
				/* tcp_destroy removes it when socket */
				/* is closed and this structure is freed. */

	int bypass_xdr_short;

};
