/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved
	
	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.
	
	This file is under Perforce control
	$Id: //depot/express/fcs70/include/avs/avsnames.h#1 $
*/
/*
 * AVS names header
 */

#ifndef _AVSNAMES_HEADER

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Default directory names
 */
#ifdef VMS
#else
#ifdef MSDOS
#define DN_AVSROOT        "\avs"
#define DN_AVSINCLUDE     "\avs\include"
#define DN_AVSDATA        "\avs\data"
#define DN_AVS_LIBRARY    "\avs\avs_library"
#define DN_ANIM           DN_AVSROOT
#else
#define DN_AVSROOT        "/usr/avs"
#define DN_AVSINCLUDE     "/usr/avs/include"
#define DN_AVSDATA        "/usr/avs/data"
#define DN_AVS_LIBRARY    "/usr/avs/avs_library"
#define DN_ANIM           DN_AVSROOT
#endif
#endif

/*
 * Subdirectory names
 */
#ifdef VMS
#define SD_BIN            "[.BIN]"
#define SD_DATA           "[.DATA]"
#define SD_INCLUDE        "[.INCLUDE]"
#define SD_LUI            "[.LUI]"
#define SD_NETWORKS       "[.NETWORKS]"
#define SD_NETWORKS_IVIEW "[.NETWORKS.IVIEW]"
#define SD_NETWORKS_DV    "[.NETWORKS.DV]"
#define SD_RUNTIME        "[.RUNTIME]"
#define SD_RUNTIME_HELP   "[.RUNTIME.HELP]"
#define SD_APPLNS_CURV_VIEWER     "[.APPLICATIONS.CURV_VIEWER]"
#define SD_APPLNS_IMAGE_VIEWER    "[.APPLICATIONS.IMAGE_VIEWER]"
#define SD_APPLNS_VECTOR_VIEWER   "[.APPLICATIONS.VECTOR_VIEWER]"
#define SD_APPLNS_VOLUME_VIEWER   "[.APPLICATIONS.VOLUME_VIEWER]"
#else
#define SD_BIN            "bin"
#define SD_DATA           "data"
#define SD_INCLUDE        "include"
#define SD_LUI            "LUI"
#define SD_NETWORKS       "networks"
#define SD_NETWORKS_IVIEW "networks/iview"
#define SD_NETWORKS_DV    "networks/dv"
#define SD_RUNTIME        "runtime"
#define SD_RUNTIME_HELP   "runtime/help"
#define SD_APPLNS_CURV_VIEWER     "applications/curv_viewer"
#define SD_APPLNS_IMAGE_VIEWER    "applications/image_viewer"
#define SD_APPLNS_VECTOR_VIEWER   "applications/vector_viewer"
#define SD_APPLNS_VOLUME_VIEWER   "applications/volume_viewer"
#endif

/*
 * Fixed file names
 */
#ifdef VMS
#define FN_VIZRC                  "[]VIZ.RC"
#define FN_VIEW_FILE              "[.RUNTIME]AVSRC.GEOM"
#define FN_RUNTIME_MODULE_DES     "[.RUNTIME]AVS.MODULE_DES"
#define FN_MODULE_DES             "AVS.MODULE_DES"
#define FN_BASE_NET               "BASE.NET"
#define FN_NOTEPAD_BINDER_PIXMAP  "[.LUI_PIXMAP]NOTEPADHOLE.X"
#define FN_NOTEPAD_TAB_PIXMAP_ON  "[.LUI_PIXMAP]TAB_ON.X"
#define FN_NOTEPAD_TAB_PIXMAP_OFF "[.LUI_PIXMAP]TAB_OFF.X"
#define FN_IMAGE_TECH_LIST        "IMAGE_TECH.LST"
#define FN_DEMO_MANSCR            "[.DEMO.MAN_SCRIPTS]"
#define FN_DEMO_MANSCR_IMAGING    "[.DEMO.MAN_SCRIPTS]IMAGING.SCR"
#define FN_DEMO_MANSCR_VOLUME     "[.DEMO.MAN_SCRIPTS]VOLUME.SCR"
#define FN_LIB_SUPPORTED          "[.AVS_LIBRARY]SUPPORTED."
#define FN_LIB_UNSUPPORTED        "[.UNSUPP_MODS]UNSUPPORTED."
#define FN_LIB_SUNVISION          "[.AVS_LIBRARY]SUNVISION."
#define FN_UPSTREAM_DATA          "[.INCLUDE]UDATA.H"
#define FN_IMAGE_DRAW             "[.INCLUDE]IMAGE_DRAW.H"
#define FN_UDATA_H                "UDATA.H"
#define FN_TEST_LAYOUT            "[.TEST]TEST.LAYOUT"
#define FN_MESSAGE_LOG            "TMP$:AVS.LOG"
#define FN_MODULE_DESC            "AVS.MODULE_DESC"
#define FN_MODDESC_TEMPLATE       "AVS_MODULE_DESC.TEMPLATE"
#define FN_RUNTIME_PRINT_HDR      "[.RUNTIME]PRINT_HDR.PS"
#define FN_RUNTIME_APPLNS         "[.RUNTIME]AVS.APPLNS"
#define FN_RUNTIME_APPLICATIONS   "[.RUNTIME]AVS.APPLICATIONS"
#define FN_RUNTIME_XDFLT_FILE     "[.RUNTIME]AVS.XDEFAULTS"
#define FN_RUNTIME_XDFLT_CLASS    "[.RUNTIME]XDEFAULTS."
#define FN_RUNTIME_AVSRC          "[.RUNTIME]AVSRC."
#define FN_RUNTIME_HOSTS          "[.RUNTIME]HOSTS."
#define FN_RUNTIME_DATA_FILES     "[.RUNTIME]DATA_FILES."
#define FN_AVSRC                  "AVSRC"
#define FN_AVSRC_TEMP             "AVSRC.TMP"
#define FN_NETWORK_EDITOR_HELP    "[.NETWORK_EDITOR]NTW_EDT"
#define FN_VBUF_SCRIPT            "TMP$:VBUF.INP"
#define FN_VBUF_SCALAR            "TMP$:VBUF.DAT"
#define FN_VBUF_IMAGE             "TMP$:VBUF.IMAGE"
#define FN_VBUF_EXEC_1            "VBUF.EXE"
#define FN_VBUF_EXEC_2            "AVSBIN$:VBUF.EXE"
#define FN_DATA_VIEWER_MEN        "DATA_VIEWER.MEN"
#else
#define FN_VIZRC                  "./.Vizrc"
#define FN_VIEW_FILE              "runtime/avsrc.geom"
#define FN_RUNTIME_MODULE_DES     "runtime/AVS.module_des"
#define FN_MODULE_DES             "AVS.module_des"
#define FN_BASE_NET               "base.net"
#define FN_NOTEPAD_BINDER_PIXMAP  "./LUI_Pixmap/NotePadHole.x"
#define FN_NOTEPAD_TAB_PIXMAP_ON  "./LUI_Pixmap/Tab.On.x"
#define FN_NOTEPAD_TAB_PIXMAP_OFF "./LUI_Pixmap/Tab.Off.x"
#define FN_IMAGE_TECH_LIST        "image_tech.lst"
#define FN_DEMO_MANSCR            "demo/man_scripts"
#define FN_DEMO_MANSCR_IMAGING    "demo/man_scripts/imaging.scr"
#define FN_DEMO_MANSCR_VOLUME     "demo/man_scripts/volume.scr"
#define FN_LIB_SUPPORTED          "avs_library/Supported"
#define FN_LIB_UNSUPPORTED        "unsupp_mods/Unsupported"
#define FN_LIB_SUNVISION          "avs_library/Sunvision"
#define FN_UPSTREAM_DATA          "include/udata.h"
#define FN_IMAGE_DRAW             "include/image_draw.h"
#define FN_UDATA_H                "udata.h"
#define FN_TEST_LAYOUT            "test/test.layout"
#define FN_MESSAGE_LOG            "/tmp/avs.log"
#define FN_MODULE_DESC            "AVS.module_desc"
#define FN_MODDESC_TEMPLATE       "AVS.module_desc.template"
#define FN_RUNTIME_PRINT_HDR      "runtime/print_hdr.ps"
#define FN_RUNTIME_APPLNS         "runtime/AVS.applns"
#define FN_RUNTIME_APPLICATIONS   "runtime/AVS.applications"
#define FN_RUNTIME_XDFLT_FILE     "runtime/avs.Xdefaults"
#define FN_RUNTIME_XDFLT_CLASS    "runtime/Xdefaults"
#define FN_RUNTIME_AVSRC          "runtime/avsrc"
#define FN_RUNTIME_HOSTS          "runtime/hosts"
#define FN_RUNTIME_DATA_FILES     "runtime/data_files"
#define FN_AVSRC                  ".avsrc"
#define FN_AVSRC_TEMP             ".avsrc.tmp"
#define FN_NETWORK_EDITOR_HELP    "network_editor/ntw_edt"
#define FN_VBUF_SCRIPT            "/tmp/vbuf.inp"
#define FN_VBUF_SCALAR            "/tmp/vbuf.dat"
#define FN_VBUF_IMAGE             "/tmp/vbuf.image"
#define FN_VBUF_EXEC_1            "vbuf"
#define FN_VBUF_EXEC_2            "/usr/avs/bin/vbuf"
#define FN_DATA_VIEWER_MEN        "data_viewer.men"
#endif

/*
 * Strings found imbedded in file names
 */
#ifdef VMS
#else
#define FS_FIELD          "fld"
#define FS_UCD            "ucd"
#define FS_GEOMETRY       "geom"
#define FS_QUANTUM        "qnt"
#define FS_MOLECULE       "mol"
#define FS_OTHER          "oth"
#endif

/*
 * File extensions
 */
#ifdef VMS
#else
#define FE_TXT            ".txt"
#define FE_OLD            ".old"
#define FE_ANIM           ".anim"
#define FE_NET            ".net"
#define FE_APP            ".app"
#define FE_POBJ           ".pobj"
#define FE_OBJ            ".obj"
#define FE_GEOM           ".geom"
#define FE_PROP           ".prop"
#define FE_SCENE          ".scene"
#define FE_X              ".x"
#define FE_IM             ".im"
#define FE_PR             ".pr"
#define FE_Z              ".z"
#define FE_SCR            ".scr"
#define FE_CYC            ".cyc"
#define FE_IMS            ".ims"
#define FE_DDIF           ".ddif"
#define FE_DAT            ".dat"
#define FE_LYT            ".lyt"
#define FE_PARMS          ".parms"
#define FE_FLD            ".fld"
#define FE_INP            ".inp"
#define FE_IMG            ".img"
#define FE_UVW            ".uvw"
#define FE_PLT            ".plt"
#define FE_PS             ".ps"
#define FE_F              ".f"
#define FE_C              ".c"
#endif

#ifdef __cplusplus
} /* End of extern "C" */
#endif

#endif
#define _AVSNAMES_HEADER 1
