/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/include/avs/cli.h#1 $
*/

#ifndef CLI_H
#define CLI_H

#ifdef __cplusplus
extern "C" {
#endif

/*********************************************************************
 * Command Table Definition support
 */

extern int CLIis_interactive();
extern int CLIis_server();
extern char *CLIcmd_name();
extern char* CLIquote(/* string */);
extern int CLIget_input(/* buf, maxlen */);

/* Command Flag values */

#define CLI_REDIRECT_OUTPUT (1L<<1)

/**********************************************************************
 * Separator characters
 */

#define CLI_NULL AVS_NULL_STR
#define CLI_PORT_CHAR ':'
#define UI_WIDGET_PARM_SEP '!'
#define UI_MODULE_PARM_SEP ':'
#define UI_CONTAINER_SEP   '!'

/****************************************/
/* Use only for command functions, not convenience functions
 * Error builds error msg and returns(FALSE)
 * CLI_CHECK_ERROR is used to catch several possible errors being built
 * May not work when casting of return NULL is required
 */
 
#define CLI_RETURN_ERROR(msg) \
   {  CLIcmd_error("%s\n", msg); return(FALSE); }

#define CLI_CHECK_ERROR(msg) { if (strlen(msg)) CLI_RETURN_ERROR(msg) }

/* Context stream buffers  */

typedef struct _cli_stream_buffer *CLI_STREAM_PTR;

#define CLI_OUTPUT      (0)      /* Output file */
#define CLI_INPUT       (1L<<0)  /* Input file */
#define CLI_NULL_OUTPUT (1L<<1)  /* Suppress any output on this stream */

/* Context flags */

#define CLI_INTERACTIVE (1L<<0)  /* Interactive with user is possible */
#define CLI_SERVER      (1L<<1)  /* Command server is in use */

/* Command flags */
#define CLI_CMD_ALIAS  (1L<<0)   /* Command is an alias for another command */
#define CLI_CMD_UNSUP  (1L<<1)   /* Command is unsupported this release     */
#define CLI_CMD_OBS    (1L<<2)	 /* Obsolete and not shown at all */

#ifdef __cplusplus
} /* End of extern "C" */
#endif

#endif /* CLI_H */
