/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/include/avs/comm.h#1 $
*/
#ifndef XP_COMM_INCLUDED
#define XP_COMM_INCLUDED

/* derived from: */
/*		@(#)avs_connect.h	7.7 AVS 92/01/03	*/
#ifndef _NFILE
#include <stdio.h>
#endif

typedef int (*COMMpfi)();

#include <avs/port.h>

#ifdef COMM_DECLARE
#define COMM_EXTERN
#else
#define COMM_EXTERN extern
#endif

COMM_EXTERN char COMM_prog_name[80];

/* if this is alpha OSF/1 or MSDOS don't include rpc/types.h */
#ifndef alpha_osf
#ifndef MSDOS
#include <rpc/types.h>
#endif
#endif

/*
 * On other systems, sys/types.h is automatically included by
 * rpc/types.h.  However, on the IBM, rpc/types.h does not
 * have this property.
 */
#ifndef MSDOS
#include <sys/types.h>
#endif


#ifndef MSDOS
#include <rpc/xdr.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <netinet/in.h>
#else	/* MSDOS */
#include "pc_xdr\types.h"
#include "pc_xdr\xdr.h"
#include <winsock.h>
#endif	/* MSDOS */


#include <avs/dtype.h>
#include <avs/arr.h>

#ifdef __cplusplus
extern "C" {
#endif

/*
 * The AVSclient_protocol table contatins a description of each kind of
 * protocol to be used in communicating from external modules to the AVS
 * kernel.
 */

/* Data structure for storing a host address */
typedef unsigned long COMMhostaddr;

/* Address types */
#define COMM_ADDR_UNIX 1
#define COMM_ADDR_TCP  2

/* The protocol version that controls the communications layer */
#define COMM_PROTO_VERSION 1

#define COMM_PROC_IDENTIFY 1

#define COMMsync(C)		 (*(C)->proto->sync_fun)(C)
#define COMMread_select(T,C,F,A) (*(C)->proto->select_fun)(T,C,F,A)
#define COMMread_req_pending(C,V) (C)->rreq_pending = V

#define COMM_HOSTNAME_LEN 128
#define COMM_SOCKFILE_LEN 128
#define COMM_ADDR_STR_LEN (COMM_HOSTNAME_LEN + COMM_SOCKFILE_LEN + 16)

#define COMM_UNIX_SOCK_PATH "/tmp/usock"

typedef struct _COMMproto_table *COMMproto_table_id;

/* The first argument to the select function is whether to add or delete */
/* the select */
#define COMM_ADD_SELECT 1
#define COMM_DEL_SELECT 2

/* Structure created by COMMcreate.. and passed around everywhere. */

/* The maximum length of a string for COMMstring_read/write */
#define COMM_MAX_STR_LEN	1024
/* The number of connects that are queued up at any given time */
#define COMM_LISTEN_QLEN	32

#define COMM_TYPE_CHAR	 DTYPE_CHAR
#define COMM_TYPE_BYTE	 DTYPE_BYTE
#define COMM_TYPE_SHORT  DTYPE_SHORT
#define COMM_TYPE_INT	 DTYPE_INT
#define COMM_TYPE_FLOAT  DTYPE_FLOAT
#define COMM_TYPE_DOUBLE DTYPE_DOUBLE
#define COMM_TYPE_LONG   DTYPE_LONG
#define COMM_TYPE_PTR	 DTYPE_PTR
#define COMM_TYPE_STRING DTYPE_STRING
#define COMM_NTYPES	 DNTYPES

typedef struct _COMMconn {
	int s;                  /* socket file number */
	char *wbuf;             /* the write buffer */
	int wf, wb;             /* front and back of the write buffer */
	char *rbuf;             /* the read buffer */
	int rf, rb;             /* front and back of the read buffer */
	void (*func) (char *);  /* function to call for select (read only) */
	char *arg;              /* argument to func (read only) */
	struct _COMMconn *sel_next;/* next function on the select list */

	XDR read_xdrs;		/* The XDR handle for reads. */
	XDR write_xdrs;		/* The XDR handle for writes. */

	enum {  COMM_LOCAL,	/* Other end is on same machine. */
		COMM_REMOTE,	/* Other end is on different machine. */
		COMM_UNKNOWN 	/* Don't know yet. */
	} other_end;
	int refcnt;		/* Number of references to this descriptor */

	int debug_level;	/* Used to record all socket reads and */
				/* writes in a file. */
				/* 1 = just the sizes of data. */
				/* 2 = all the data too. */
	FILE *debug_fp;		/* File for use with above. */

	/*
	 * Array of flags for each type -- bypass xdr translation if it
	 * is true.
	 */
	int bypass[COMM_NTYPES];

	int proto_vers;		/* Highest protocol version understood */
				/* by both ends of the socket. */

	COMMhostaddr other_host_addr;/* Host address on other end of socket. */
	int other_pid;		/* Process id on other end of socket. */

	struct _COMMconn *next_open;/* Used to maintain */
				/* linked list of all open connections.  */
	COMMproto_table_id proto;
	int non_block;		/* True if non-blocking io is set up */
	int rreq_pending;	/* True if in the middle of reading a request */
	void (*destroy_func) (void *);
	void *destroy_arg;
	unsigned int destroyed:1;
	void *rp_info;		/* pointer to RP information */
} COMMconn;

/*
 * The address contains the information that needs to be communicated
 * to the remote process in order to attach to it.
 */
typedef struct _COMMaddr {
   int type; /* Address type: COMM_ADDR_...*/
   union {
#ifdef USE_SOCKETS
      struct sockaddr_in tcp_addr; /* Contains my host id and my port */
      struct _unix_addr {
	 char hostname[COMM_HOSTNAME_LEN];
         char sockfile[COMM_SOCKFILE_LEN];
      } unix_addr;
#else
      int dummy;
#endif
   } i;
} COMMaddr;


typedef struct _COMMserver {
   int fd;
   void (*func) (struct _COMMconn *);
   COMMaddr addr;
} COMMserver;

/*
 * If you want to implement a new protocol, you can implement these functions
 * to accomplish that.  The protocol requires:
 *   - ability to perform non-blocking partial reads and writes
 *   - select-like functionality
 *   - reliable read and write streams of data
 */
typedef struct _COMMproto_table {
   xp_long (*read_fun) (COMMconn *, char *, xp_long);
   xp_long (*write_fun) (COMMconn *, char *, xp_long);
   int (*sync_fun) (COMMconn *);
   int (*destroy_fun) (COMMconn *);
   int (*select_fun) (int, COMMconn *, void (*)(char *), char *);
   int (*incr_fun) (COMMconn *);
   int (*fd_fun) (COMMconn *); /* Returns a file descriptor */
   int (*need_read_fun) (COMMconn *, int);
   int (*need_write_fun) (COMMconn *,int);
} COMMproto_table;

#define COMMinteger_read(C,P)  COMMprim_read(C,COMM_TYPE_INT,(char *)P)
#define COMMlong_read(C,P)  	 COMMprim_read(C,COMM_TYPE_LONG,(char *)P)
#define COMMinteger_array_write(C,P,L,O) \
   COMMarray_write(C,COMM_TYPE_INT,(char *)P,L,O)
#define COMMinteger_array_read(C,P,L,O) \
   COMMarray_read(C,COMM_TYPE_INT,(char **)P,L,O)

COMMconn *COMM_init_conn  (int, COMMhostaddr);
COMMconn *COMMcreate_conn (int, COMMproto_table *);
COMMserver *COMMserver_init (int, void (*)(COMMconn *));
COMMaddr *COMMbuild_unix_addr (char *, char *);
COMMaddr *COMMbuild_tcp_addr (char *, int);
void COMMfree_addr (COMMaddr *);
int COMMset_non_block (COMMconn *, int);
COMMconn *COMMattach (COMMaddr *);
void COMMdestroy (COMMconn *);
void COMMset_destroy_func (COMMconn *, void (*func) (void *), void *);

void COMMinit (const char *prog_name);

void COMMserver_destroy (COMMserver *server);

void COMMstring_to_addr (char buf[COMM_ADDR_STR_LEN], COMMaddr *addr);

void COMMaddr_to_string (COMMaddr *addr, char buf[COMM_ADDR_STR_LEN]);

void COMMinternal_error (const char *str);
void COMMerror (const char *str);

int COMMneed_read (COMMconn *conn, int size);

xp_long COMMarray_read  (COMMconn *conn, int type, char **, xp_long, xp_long);
int COMMprim_read   (COMMconn *conn, int type, char *datap);
xp_long COMMarray_write (COMMconn *conn, int type, char *, xp_long, xp_long);
int COMMprim_write  (COMMconn *conn, int type, char *data);

int COMMbyte_write    (COMMconn *conn, int val);
int COMMshort_write   (COMMconn *conn, int val);
int COMMinteger_write (COMMconn *conn, int val);
int COMMfloat_write   (COMMconn *conn, double val);
int COMMdouble_write  (COMMconn *conn, double val);
int COMMlong_write    (COMMconn *conn, xp_long val);

#ifdef __cplusplus
} /* End of extern "C" */
#endif

#endif
