//			Copyright (c) 1993 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/include/avs/cxxutl/attr.cxx#1 $
//

// attr.cxx - Source file for UtAttr and UtEnumAttr classes

//----------------------------------------------------------------------

#ifndef CXXUTIL_ATTR_HXX
#include "attr.hxx"
#endif

//----------------------------------------------------------------------
template <class TYPE> 
void 
UtAttr<TYPE>::init() 
//----------------------------------------------------------------------
{
    _state = UtATTR_INIT;
    _init();
}

//----------------------------------------------------------------------
template <class TYPE> 
void 
UtAttr<TYPE>::set(
    const TYPE &value) 
//----------------------------------------------------------------------
{
    _value = value;
    setState(UtATTR_USER_SET);
    // validate value and set to ATTR_UNSET if value is illegal
    _validate();
}


//----------------------------------------------------------------------
template<class ENUM_TYPE>
UtEnumAttr<ENUM_TYPE>::UtEnumAttr(const char *name) 
    : UtAttr<ENUM_TYPE>(name) 
//----------------------------------------------------------------------
{}

//----------------------------------------------------------------------
template<class ENUM_TYPE>
void 
UtEnumAttr<ENUM_TYPE>::_validate() 
//----------------------------------------------------------------------
{
    if (!this->_value.valid()) this->setState(UtATTR_UNSET);
}

//----------------------------------------------------------------------
template <class TYPE> 
UtRangeAttr<TYPE>::UtRangeAttr(
    const char *name, 
    TYPE min, 
    TYPE max) 
    : UtAttr<TYPE>(name), _min(min), _max(max) 
//----------------------------------------------------------------------
{}

//----------------------------------------------------------------------
template <class TYPE> 
void 
UtRangeAttr<TYPE>::_validate() 
//----------------------------------------------------------------------
{
    if (this->_value < _min) this->_value = _min;
    if (this->_value > _max) this->_value = _max;
}

//----------------------------------------------------------------------
template <class TYPE> 
void 
UtRangeAttr<TYPE>::setRange(
    TYPE min, 
    TYPE max) 
//----------------------------------------------------------------------
{
    _min = min;
    _max = max;
}


//----------------------------------------------------------------------
template <class TYPE> 
UtMinRangeAttr<TYPE>::UtMinRangeAttr(
    const char *name, 
    TYPE min) 
    : UtAttr<TYPE>(name), _min(min) 
//----------------------------------------------------------------------
{}

//----------------------------------------------------------------------
template <class TYPE> 
void 
UtMinRangeAttr<TYPE>::_validate() 
//----------------------------------------------------------------------
{
    if (this->_value < _min) this->_value = _min;
}

//----------------------------------------------------------------------
template <class TYPE> 
void 
UtMinRangeAttr<TYPE>::setMin(
    TYPE min) 
//----------------------------------------------------------------------
{
    _min = min;
}

