//			Copyright (c) 1993 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/include/avs/cxxutl/attr.hxx#1 $
//

// ATTR.hxx - Header file for UtArrr and UtEnumAttr classes

//----------------------------------------------------------------------
#ifndef CXXUTIL_ATTR_HXX
#define CXXUTIL_ATTR_HXX

#ifndef CXXUTIL_PORT_HXX
#include <avs/cxxutl/port.hxx>
#endif

#ifndef CXXUTIL_BASEATTR_HXX
#include "baseattr.hxx"
#endif

//----------------------------------------------------------------------
//  Protected base class for each specific attribute type
//----------------------------------------------------------------------
template<class TYPE> 
class UtAttr : public UtBaseAttr 
//----------------------------------------------------------------------
{
  public:
    TYPE &get() {return _value;}
    void set(const TYPE &value);    
    // Init attribute to the default values
    virtual void init();
  protected:
    UtAttr(const char *name) : UtBaseAttr(name) {}
    TYPE _value;
};

//----------------------------------------------------------------------
// Protected base class for enum attribute types
//----------------------------------------------------------------------
template<class ENUM_TYPE>
class UtEnumAttr : public UtAttr<ENUM_TYPE> 
//----------------------------------------------------------------------
{
  protected:
    UtEnumAttr(const char *name);
    virtual void _validate();
};

//----------------------------------------------------------------------
// Protected base class for float with range attribute types
//----------------------------------------------------------------------
template<class TYPE>
class UtRangeAttr : public UtAttr<TYPE> 
//----------------------------------------------------------------------
{
  protected:
    UtRangeAttr(const char *name, TYPE min, TYPE max);
    virtual void _validate();
    void setRange(TYPE min, TYPE max);
    TYPE _min, _max;
};

//----------------------------------------------------------------------
// Protected base class for float which must be >= _min attribute types
//----------------------------------------------------------------------
template<class TYPE>
class UtMinRangeAttr : public UtAttr<TYPE> 
//----------------------------------------------------------------------
{
  protected:
    UtMinRangeAttr(const char *name, TYPE min);
    virtual void _validate();
    void setMin(TYPE min);
    TYPE _min;
};

// This is neccesary for "modern" template instantiation techniques
#ifdef CXX_TEMPLATES_INCLUDE_CXX_FILE
#include "attr.cxx"
#endif

#endif
