//			Copyright (c) 1998 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//	
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//	
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/include/avs/cxxutl/datetime.hxx#1 $
//

// Header file for UtDateTime and UtDate classes

//----------------------------------------------------------------------

#ifndef CXXUTIL_DATETIME_HXX
#define CXXUTIL_DATETIME_HXX

#include <time.h>
#ifdef XP_STD_IOSTREAM
#include <iostream>
#else
#include <iostream.h>
#endif

#ifndef CXXUTIL_STRING_HXX
#include <avs/cxxutl/string.hxx>
#endif

enum DateTimePrintForm {
    Date_American, 
    Date_Numbers, 
    Date_European,
    Time_Normal,
    Time_Military
};

class UtDateTime {

public:
    UtDateTime( ) { _time = 0; }
    UtDateTime( time_t time ) { _time = time; }	// constructor;

    static UtDateTime Now( );
    UtString PrintString (DateTimePrintForm form = Date_American) const;

protected:
    time_t _time;
};


class UtDate : public UtDateTime {
public:
    UtDate( ) { _time = 0; }
    UtDate( short yy, short mm, short dd );
};

ostream& operator<< (ostream& s, const UtDate& date);

#endif

