//			Copyright (c) 1993 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/include/avs/cxxutl/enum.hxx#1 $
//

// enum.hxx - Header file for UtBaseEnum and UtEnum classes

//----------------------------------------------------------------------
#ifndef CXXUTIL_ENUM_HXX
#define CXXUTIL_ENUM_HXX

//----------------------------------------------------------------------
// Struct to store one valid enum value of string/int pair
//----------------------------------------------------------------------
struct UtEnumObj
//----------------------------------------------------------------------
{
    const char *_stringValue;
    int _intValue;
};

// Forward class declaration
template <class TYPE> class UtAttr;

//----------------------------------------------------------------------
// Protected base class to store enumerated value in
//----------------------------------------------------------------------
class UtBaseEnum
//----------------------------------------------------------------------
{
    friend class UtAttr<UtBaseEnum>;

  public:
    int valid() const {return _currentValue != 0;}
    operator const char*() const;
    operator int() const;
    const UtBaseEnum& operator= (const char* stringValue);

    const UtBaseEnum& operator= (int intValue);
    // since there is both an operator=(int) and an operator int() 
    // we need a default assignment constructor to avoid the above being used
    UtBaseEnum& operator= (const UtBaseEnum& from);

  protected:
    UtBaseEnum() : _currentValue(0) {}

    UtEnumObj *_legalValues;

  private:
    UtEnumObj *_currentValue;
};

//----------------------------------------------------------------------
// Protected base class for storing enumerated values
// Please not that it needs a pointer to an array of legal
// values (string/int pairs) for the enum
//----------------------------------------------------------------------
template<UtEnumObj *LEGAL_VALUES>
class UtEnum : public UtBaseEnum
//----------------------------------------------------------------------
{
  public:
    UtEnum() {
        _legalValues = LEGAL_VALUES;
    }
    UtEnum(const char * stringValue) {
        _legalValues = LEGAL_VALUES;
        (void) UtBaseEnum::operator=(stringValue);
    }
    UtEnum(int intValue) {
        _legalValues = LEGAL_VALUES;
        (void) UtBaseEnum::operator=(intValue);
    }
    const UtEnum<LEGAL_VALUES>& operator= (const char *stringValue) {
        return (UtEnum<LEGAL_VALUES>&)UtBaseEnum::operator=(stringValue);
    }
    const UtEnum<LEGAL_VALUES>& operator= (int intValue) {
        return (UtEnum<LEGAL_VALUES>&)UtBaseEnum::operator=(intValue);
    }
    // since there is both an operator=(int) and an operator int() 
    // we need a default assignment constructor to avoid the above being used
    UtEnum<LEGAL_VALUES>& operator= (const UtEnum<LEGAL_VALUES> &from) {
        return (UtEnum<LEGAL_VALUES>&)UtBaseEnum::operator=(from);
    }
  protected:
  private:
};

#endif

