//			Copyright (c) 1993 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/include/avs/cxxutl/misc.hxx#1 $
//

// misc.hxx - Miscelanous utilities

//----------------------------------------------------------------------
#ifndef CXXUTIL_MISC_HXX
#define CXXUTIL_MISC_HXX

#include <avs/port.h>

//----------------------------------------------------------------------
// Find min of two values
//----------------------------------------------------------------------

template <class TYPE>
inline TYPE UtMin(TYPE value1, TYPE value2)
//----------------------------------------------------------------------
{
  return (value1 < value2 ? value1 : value2);
}

#ifdef WORDLENGTH_64
/* 64-bit porting. Newly Introduced */
template <class TYPE1,class TYPE2>
inline TYPE1 UtMin(TYPE1 value1, TYPE2 value2)
//----------------------------------------------------------------------
{
  return (value1 < value2 ? value1 : value2);
}
#endif

//----------------------------------------------------------------------
// Find max of two values
//----------------------------------------------------------------------

template <class TYPE>
inline TYPE UtMax(TYPE value1, TYPE value2)
//----------------------------------------------------------------------
{
  return (value1 > value2 ? value1 : value2);
}

#ifdef WORDLENGTH_64
/* 64-bit porting. Newly Introduced */
template <class TYPE1,class TYPE2>
inline TYPE1 UtMax(TYPE1 value1, TYPE2 value2)
//----------------------------------------------------------------------
{
  return (value1 > value2 ? value1 : value2);
}
#endif

//----------------------------------------------------------------------
// Return absolute value
//----------------------------------------------------------------------

template <class TYPE>
inline TYPE UtAbs(TYPE value)
//----------------------------------------------------------------------
{
  return (value > 0 ? value : -value);
}

#endif
